/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/properties")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="properties")
public interface IPropertiesServiceV2 {
    @GET
    @Path(value="/")
    @ApiOperation(value="Gets all available properties", notes="Retrieves all properties associated with the application, eg. the app title, or the logo hyperlink.", response=Map.class, produces="application/json", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getProperties();

    @GET
    @Path(value="/{propertyName}")
    @Produces(value={"text/plain", "application/json"})
    @ApiOperation(value="Gets the property value for the specified property name", notes="Retrieves the value of the provided system property.", response=String.class, produces="text/plain", responseHeaders={@ResponseHeader(name="X-Gaffer-Media-Type", description="The gaffer media type containing the REST API version.")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Property not found"), @ApiResponse(code=500, message="Something went wrong in the server")})
    public Response getProperty(@ApiParam(value="The property name for which the value should be retrieved") @PathParam(value="propertyName") String var1);
}

