/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.rest.service.v2.example;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import uk.gov.gchq.gaffer.data.element.Edge;
import uk.gov.gchq.gaffer.data.element.Element;
import uk.gov.gchq.gaffer.data.element.Entity;
import uk.gov.gchq.gaffer.data.element.IdentifierType;
import uk.gov.gchq.gaffer.data.element.comparison.ElementPropertyComparator;
import uk.gov.gchq.gaffer.data.element.id.EdgeId;
import uk.gov.gchq.gaffer.data.element.id.EntityId;
import uk.gov.gchq.gaffer.data.elementdefinition.view.GlobalViewElementDefinition;
import uk.gov.gchq.gaffer.data.elementdefinition.view.View;
import uk.gov.gchq.gaffer.data.generator.MapGenerator;
import uk.gov.gchq.gaffer.named.view.AddNamedView;
import uk.gov.gchq.gaffer.operation.Operation;
import uk.gov.gchq.gaffer.operation.OperationChain;
import uk.gov.gchq.gaffer.operation.data.EdgeSeed;
import uk.gov.gchq.gaffer.operation.data.EntitySeed;
import uk.gov.gchq.gaffer.operation.impl.GetWalks;
import uk.gov.gchq.gaffer.operation.impl.If;
import uk.gov.gchq.gaffer.operation.impl.Limit;
import uk.gov.gchq.gaffer.operation.impl.While;
import uk.gov.gchq.gaffer.operation.impl.add.AddElements;
import uk.gov.gchq.gaffer.operation.impl.compare.Max;
import uk.gov.gchq.gaffer.operation.impl.compare.Min;
import uk.gov.gchq.gaffer.operation.impl.compare.Sort;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateElements;
import uk.gov.gchq.gaffer.operation.impl.generate.GenerateObjects;
import uk.gov.gchq.gaffer.operation.impl.get.GetAdjacentIds;
import uk.gov.gchq.gaffer.operation.impl.get.GetAllElements;
import uk.gov.gchq.gaffer.operation.impl.get.GetElements;
import uk.gov.gchq.gaffer.operation.impl.output.ToMap;
import uk.gov.gchq.gaffer.operation.io.InputOutput;
import uk.gov.gchq.gaffer.operation.io.Output;
import uk.gov.gchq.gaffer.rest.example.ExampleDomainObject;
import uk.gov.gchq.gaffer.rest.example.ExampleDomainObjectGenerator;
import uk.gov.gchq.gaffer.rest.example.ExampleElementGenerator;
import uk.gov.gchq.gaffer.rest.factory.GraphFactory;
import uk.gov.gchq.gaffer.rest.service.v2.example.ExamplesFactory;
import uk.gov.gchq.gaffer.store.schema.Schema;
import uk.gov.gchq.gaffer.store.schema.SchemaEdgeDefinition;
import uk.gov.gchq.gaffer.store.schema.SchemaElementDefinition;
import uk.gov.gchq.gaffer.store.schema.SchemaEntityDefinition;
import uk.gov.gchq.koryphe.impl.predicate.IsLongerThan;

public class DefaultExamplesFactory
implements ExamplesFactory {
    @Inject
    private GraphFactory graphFactory;
    private Map<Class<? extends Operation>, Operation> examplesMap;

    @PostConstruct
    public void generateExamples() {
        HashMap<Class<While>, Object> map = new HashMap<Class<While>, Object>();
        map.put(GetAllElements.class, this.getAllElements());
        map.put(GetElements.class, this.getElements());
        map.put(GetAdjacentIds.class, this.getAdjacentIds());
        map.put(AddElements.class, this.addElements());
        map.put(GenerateObjects.class, this.generateObjects());
        map.put(GenerateElements.class, this.generateElements());
        map.put(OperationChain.class, this.operationChain());
        map.put(Sort.class, this.sort());
        map.put(Max.class, this.max());
        map.put(Min.class, this.min());
        map.put(ToMap.class, this.toMap());
        map.put(GetWalks.class, this.getWalks());
        map.put(AddNamedView.class, this.addNamedView());
        map.put(If.class, this.ifOperation());
        map.put(While.class, this.whileOperation());
        this.examplesMap = map;
    }

    public Operation generateExample(Class<? extends Operation> opClass) throws IllegalAccessException, InstantiationException {
        if (null == this.examplesMap) {
            this.generateExamples();
        }
        if (this.examplesMap.containsKey(opClass)) {
            return (Operation)this.examplesMap.get(opClass);
        }
        Operation operation = opClass.newInstance();
        List<Field> fields = Arrays.asList(opClass.getDeclaredFields());
        for (Field field : fields) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.set(operation, this.getExampleValue(field.getType(), ThreadLocalRandom.current().nextInt(0, 11)));
        }
        return operation;
    }

    private Object getExampleValue(Class clazz, int uniqueId) {
        Object value;
        if (null == clazz) {
            value = null;
        } else if (Character.class.equals((Object)clazz) || Character.TYPE.equals(clazz)) {
            value = Character.valueOf((char)uniqueId);
        } else if (String.class.equals((Object)clazz) || Object.class.equals((Object)clazz)) {
            value = String.valueOf(uniqueId);
        } else if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            value = uniqueId;
        } else if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            value = (double)uniqueId + 0.1;
        } else if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            value = (long)uniqueId;
        } else if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            value = Float.valueOf(uniqueId);
        } else if (Date.class.equals((Object)clazz)) {
            value = new Date(System.currentTimeMillis() - 10000L + (long)uniqueId);
        } else if (Boolean.TYPE.equals(clazz)) {
            value = uniqueId % 2 == 0;
        } else {
            try {
                List l;
                value = clazz.isEnum() ? (!(l = Arrays.asList(clazz.getEnumConstants())).isEmpty() ? Enum.valueOf(clazz, l.get(0).toString()) : clazz.newInstance()) : clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                value = null;
            }
        }
        return value;
    }

    private Schema getSchema() {
        return this.graphFactory.getGraph().getSchema();
    }

    protected Entity getEntity(int uniqueId) {
        String group = this.getAnEntityGroup();
        SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(group);
        Entity entity = new Entity.Builder().group(group).vertex(this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), uniqueId)).build();
        this.populateProperties((Element)entity, entityDef, uniqueId);
        return entity;
    }

    protected Edge getEdge(int uniqueId1, int uniqueId2) {
        String group = this.getAnEdgeGroup();
        SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(group);
        Edge edge = new Edge.Builder().group(group).source(this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.SOURCE), uniqueId1)).dest(this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.DESTINATION), uniqueId2)).directed(this.isAnEdgeDirected()).build();
        this.populateProperties((Element)edge, edgeDef, uniqueId1);
        return edge;
    }

    protected EntityId getEntityId(int uniqueId) {
        return new EntitySeed(this.getExampleVertex(((SchemaEntityDefinition)this.getSchema().getEntity(this.getAnEntityGroup())).getIdentifierClass(IdentifierType.VERTEX), uniqueId));
    }

    protected EdgeId getEdgeId(int uniqueId1, int uniqueId2) {
        return new EdgeSeed(this.getExampleVertex(((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getIdentifierClass(IdentifierType.SOURCE), uniqueId1), this.getExampleVertex(((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getIdentifierClass(IdentifierType.DESTINATION), uniqueId2), this.isAnEdgeDirected());
    }

    protected boolean isAnEdgeDirected() {
        return !((SchemaEdgeDefinition)this.getSchema().getEdge(this.getAnEdgeGroup())).getDirected().toLowerCase(Locale.getDefault()).contains("false");
    }

    protected String getAnEntityPropertyName() {
        SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(this.getAnEntityGroup());
        String propertyName = null;
        if (null != entityDef && !entityDef.getProperties().isEmpty()) {
            propertyName = (String)entityDef.getProperties().iterator().next();
        }
        return propertyName;
    }

    protected String getAnEntityGroup() {
        if (!this.getSchema().getEntityGroups().isEmpty()) {
            for (Map.Entry entry : this.getSchema().getEntities().entrySet()) {
                if (null == ((SchemaEntityDefinition)entry.getValue()).getProperties() || ((SchemaEntityDefinition)entry.getValue()).getProperties().isEmpty()) continue;
                return (String)entry.getKey();
            }
            return (String)this.getSchema().getEntityGroups().iterator().next();
        }
        return "exampleEntityGroup";
    }

    protected String getAnEdgePropertyName() {
        SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(this.getAnEdgeGroup());
        String propertyName = null != edgeDef && !edgeDef.getProperties().isEmpty() ? (String)edgeDef.getProperties().iterator().next() : "examplePropertyName";
        return propertyName;
    }

    protected String getAnEdgeGroup() {
        if (!this.getSchema().getEdgeGroups().isEmpty()) {
            for (Map.Entry entry : this.getSchema().getEdges().entrySet()) {
                if (null == ((SchemaEdgeDefinition)entry.getValue()).getProperties() || ((SchemaEdgeDefinition)entry.getValue()).getProperties().isEmpty()) continue;
                return (String)entry.getKey();
            }
            return (String)this.getSchema().getEdgeGroups().iterator().next();
        }
        return "exampleEdgeGroup";
    }

    protected boolean hasEdges() {
        return !this.getSchema().getEdges().isEmpty();
    }

    protected boolean hasEntities() {
        return !this.getSchema().getEntities().isEmpty();
    }

    protected void populateProperties(Element element, SchemaElementDefinition elementDef, int uniqueId) {
        for (String property : elementDef.getProperties()) {
            element.putProperty(property, this.getExampleValue(elementDef.getPropertyClass(property), uniqueId));
        }
    }

    protected Object getExampleVertex(Class<?> clazz, int uniqueId) {
        if (String.class.equals(clazz) || Object.class.equals(clazz)) {
            return "vertex" + uniqueId;
        }
        return this.getExampleValue(clazz, uniqueId);
    }

    public GetAdjacentIds getAdjacentIds() {
        GetAdjacentIds op = new GetAdjacentIds();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public GetAllElements getAllElements() {
        GetAllElements op = new GetAllElements();
        this.populateOperation((Output)op);
        return op;
    }

    public GetElements getElements() {
        GetElements op = new GetElements();
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        if (this.hasEdges()) {
            seeds.add(this.getEdgeId(1, 2));
        }
        op.setInput(seeds);
        this.populateOperation((Output)op);
        return op;
    }

    public AddElements addElements() {
        AddElements op = new AddElements();
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.hasEntities()) {
            elements.add(this.getEntity(1));
            elements.add(this.getEntity(2));
        }
        if (this.hasEdges()) {
            elements.add(this.getEdge(1, 2));
        }
        op.setInput(elements);
        this.populateOperation((Operation)op);
        return op;
    }

    public GenerateObjects generateObjects() {
        GenerateObjects op = new GenerateObjects((Function)new ExampleDomainObjectGenerator());
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.hasEntities()) {
            elements.add(this.getEntity(1));
            elements.add(this.getEntity(2));
        }
        if (this.hasEdges()) {
            elements.add(this.getEdge(1, 2));
        }
        op.setInput(elements);
        this.populateOperation((Output)op);
        return op;
    }

    public GenerateElements generateElements() {
        GenerateElements op = new GenerateElements((Function)new ExampleElementGenerator());
        ArrayList<ExampleDomainObject> objs = new ArrayList<ExampleDomainObject>();
        if (this.hasEntities()) {
            SchemaElementDefinition entityDef = (SchemaElementDefinition)this.getSchema().getEntity(this.getAnEntityGroup());
            objs.add(new ExampleDomainObject(this.getAnEntityGroup(), new Object[]{this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), 1)}));
            objs.add(new ExampleDomainObject(this.getAnEntityGroup(), new Object[]{this.getExampleVertex(entityDef.getIdentifierClass(IdentifierType.VERTEX), 2)}));
        }
        if (this.hasEdges()) {
            SchemaElementDefinition edgeDef = (SchemaElementDefinition)this.getSchema().getEdge(this.getAnEdgeGroup());
            objs.add(new ExampleDomainObject(this.getAnEdgeGroup(), new Object[]{this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.SOURCE), 1), this.getExampleVertex(edgeDef.getIdentifierClass(IdentifierType.DESTINATION), 1), this.isAnEdgeDirected()}));
        }
        op.setInput(objs);
        this.populateOperation((Output)op);
        return op;
    }

    public Sort sort() {
        return (Sort)new Sort.Builder().comparators(new Comparator[]{new ElementPropertyComparator.Builder().groups(new String[]{this.getAnEdgeGroup()}).property(this.getAnEntityPropertyName()).reverse(true).build()}).resultLimit(Integer.valueOf(20)).deduplicate(true).build();
    }

    public Max max() {
        return (Max)new Max.Builder().comparators(new Comparator[]{new ElementPropertyComparator.Builder().groups(new String[]{this.getAnEdgeGroup()}).property(this.getAnEdgePropertyName()).build()}).build();
    }

    public Min min() {
        return (Min)new Min.Builder().comparators(new Comparator[]{new ElementPropertyComparator.Builder().groups(new String[]{this.getAnEdgeGroup()}).property(this.getAnEdgePropertyName()).build()}).build();
    }

    public ToMap toMap() {
        return (ToMap)new ToMap.Builder().generator(new MapGenerator.Builder().group(this.getAnEdgeGroup()).source("source").property(this.getAnEdgePropertyName(), "edge property " + this.getAnEdgePropertyName()).build()).build();
    }

    public GetWalks getWalks() {
        ArrayList edges = new ArrayList(this.getSchema().getEdgeGroups());
        if (edges.isEmpty()) {
            return new GetWalks();
        }
        EntityId entityId = this.getEntityId(1);
        if (null == entityId.getVertex()) {
            entityId.setVertex((Object)"vertex1");
        }
        return (GetWalks)((GetWalks.Builder)new GetWalks.Builder().input(new EntityId[]{entityId})).operations(new Output[]{(Output)((GetElements.Builder)new GetElements.Builder().view(((View.Builder)new View.Builder().edge(edges.size() > 1 ? (String)edges.get(1) : (String)edges.get(0))).build())).build()}).resultsLimit(Integer.valueOf(10000)).build();
    }

    public AddNamedView addNamedView() {
        return (AddNamedView)new AddNamedView.Builder().name("summarise").description("Summarises all elements").overwrite(true).view(((View.Builder)new View.Builder().globalElements(new GlobalViewElementDefinition[]{((GlobalViewElementDefinition.Builder)new GlobalViewElementDefinition.Builder().groupBy(new String[0])).build()})).build()).build();
    }

    public If ifOperation() {
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        return (If)((If.Builder)new If.Builder().input(seeds)).conditional((Predicate)new IsLongerThan(0)).then((Operation)new GetElements()).otherwise((Operation)new OperationChain.Builder().first((Output)new GetAllElements()).then((InputOutput)new Limit(Integer.valueOf(10))).build()).build();
    }

    public While whileOperation() {
        ArrayList<Object> seeds = new ArrayList<Object>();
        if (this.hasEntities()) {
            seeds.add(this.getEntityId(1));
        } else if (this.hasEdges()) {
            seeds.add(new EntitySeed(this.getEdgeId(1, 2).getSource()));
        }
        return (While)((While.Builder)new While.Builder().input(seeds)).conditional((Predicate)new IsLongerThan(0)).operation((Operation)new GetAdjacentIds()).maxRepeats(Integer.valueOf(10)).build();
    }

    public OperationChain operationChain() {
        return new OperationChain.Builder().first((Output)this.getAllElements()).then((InputOutput)new Limit(Integer.valueOf(1))).build();
    }

    private void populateOperation(Output operation) {
        this.populateOperation((Operation)operation);
    }

    protected void populateOperation(Operation operation) {
    }
}

