/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;

public abstract class JSONSerialisationTest<T> {
    @Test
    public void shouldJsonSerialiseAndDeserialise() {
        T obj = this.getTestObject();
        byte[] json = this.toJson(obj);
        T deserialisedObj = this.fromJson(json);
        Assert.assertNotNull(deserialisedObj);
    }

    @Test
    public void shouldHaveJsonPropertyAnnotation() throws Exception {
        T op = this.getTestObject();
        JsonPropertyOrder annotation = op.getClass().getAnnotation(JsonPropertyOrder.class);
        Assume.assumeTrue((String)("Missing JsonPropertyOrder annotation on class. It should de defined and set to alphabetical." + op.getClass().getName()), (null != annotation && annotation.alphabetic() ? 1 : 0) != 0);
    }

    protected abstract T getTestObject();

    protected byte[] toJson(T testObj) {
        try {
            return JSONSerialiser.serialise(testObj, (boolean)true, (String[])new String[0]);
        }
        catch (SerialisationException e) {
            throw new RuntimeException(e);
        }
    }

    protected T fromJson(byte[] jsonObj) {
        try {
            return (T)JSONSerialiser.deserialise((byte[])jsonObj, this.getTestObject().getClass());
        }
        catch (SerialisationException e) {
            throw new RuntimeException(e);
        }
    }
}

