/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.jsonSerialisation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.gov.gchq.gaffer.commonutil.JsonAssert;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiserModules;
import uk.gov.gchq.gaffer.serialisation.ParameterisedTestObject;
import uk.gov.gchq.gaffer.serialisation.SimpleTestObject;

public class JSONSerialiserTest {
    private final Pair<Object, byte[]>[] historicSerialisationPairs;

    public JSONSerialiserTest() {
        ParameterisedTestObject<Integer> paramTest = new ParameterisedTestObject<Integer>();
        paramTest.setX("Test");
        paramTest.setK(2);
        SimpleTestObject simpleTestObject = new SimpleTestObject();
        simpleTestObject.setX("Test");
        this.historicSerialisationPairs = new Pair[]{new Pair((Object)simpleTestObject, (Object)new byte[]{123, 34, 120, 34, 58, 34, 84, 101, 115, 116, 34, 125}), new Pair(paramTest, (Object)new byte[]{123, 34, 120, 34, 58, 34, 84, 101, 115, 116, 34, 44, 34, 107, 34, 58, 50, 125})};
    }

    @Before
    @After
    public void cleanUp() {
        System.clearProperty("gaffer.serialiser.json.class");
        System.clearProperty("gaffer.serialiser.json.modules");
        JSONSerialiser.update();
    }

    @Test
    public void testPrimitiveSerialisation() throws IOException {
        byte[] b = JSONSerialiser.serialise((Object)2, (String[])new String[0]);
        Object o = JSONSerialiser.deserialise((byte[])b, Object.class);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void canHandleUnParameterisedDAO() throws SerialisationException {
        Assert.assertTrue((boolean)JSONSerialiser.canHandle(SimpleTestObject.class));
    }

    @Test
    public void testDAOSerialisation() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("Test");
        byte[] b = JSONSerialiser.serialise((Object)test, (String[])new String[0]);
        Object o = JSONSerialiser.deserialise((byte[])b, SimpleTestObject.class);
        Assert.assertEquals(SimpleTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)((SimpleTestObject)o).getX());
    }

    @Test
    public void shouldNotPrettyPrintByDefaultWhenSerialising() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("TestValue1");
        byte[] bytes = JSONSerialiser.serialise((Object)test, (String[])new String[0]);
        Assert.assertEquals((Object)"{\"x\":\"TestValue1\"}", (Object)new String(bytes));
    }

    @Test
    public void shouldPrettyPrintWhenSerialisingAndSetToPrettyPrint() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("TestValue1");
        byte[] bytes = JSONSerialiser.serialise((Object)test, (boolean)true, (String[])new String[0]);
        JsonAssert.assertEquals((String)String.format("{%n  \"x\" : \"TestValue1\"%n}", new Object[0]), (String)new String(bytes));
    }

    @Test
    public void canHandleParameterisedDAO() throws SerialisationException {
        Assert.assertTrue((boolean)JSONSerialiser.canHandle(ParameterisedTestObject.class));
    }

    @Test
    public void testParameterisedDAOSerialisation() throws SerialisationException {
        ParameterisedTestObject<Integer> test = new ParameterisedTestObject<Integer>();
        test.setX("Test");
        test.setK(2);
        byte[] b = JSONSerialiser.serialise(test, (String[])new String[0]);
        Object o = JSONSerialiser.deserialise((byte[])b, ParameterisedTestObject.class);
        Assert.assertEquals(ParameterisedTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)((ParameterisedTestObject)o).getX());
        Assert.assertEquals(Integer.class, ((ParameterisedTestObject)o).getK().getClass());
        Assert.assertEquals((Object)2, ((ParameterisedTestObject)o).getK());
    }

    @Test
    public void testParameterisedDAOTypeRefDeserialisation() throws SerialisationException {
        ParameterisedTestObject<Integer> test = new ParameterisedTestObject<Integer>();
        test.setX("Test");
        test.setK(2);
        byte[] b = JSONSerialiser.serialise(test, (String[])new String[0]);
        ParameterisedTestObject o = (ParameterisedTestObject)JSONSerialiser.deserialise((byte[])b, (TypeReference)new TypeReference<ParameterisedTestObject<Integer>>(){});
        Assert.assertEquals((Object)"Test", (Object)o.getX());
        Assert.assertEquals((Object)2, o.getK());
    }

    @Test
    public void testParameterisedDeserialisationOfComplexObject() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("Test");
        byte[] b = JSONSerialiser.serialise((Object)test, (String[])new String[0]);
        SimpleTestObject o = (SimpleTestObject)JSONSerialiser.deserialise((byte[])b, SimpleTestObject.class);
        Assert.assertEquals(SimpleTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)o.getX());
    }

    @Test
    public void testParameterisedDeserialisationOfParameterisedComplexObject() throws SerialisationException {
        ParameterisedTestObject<Integer> test = new ParameterisedTestObject<Integer>();
        test.setX("Test");
        test.setK(2);
        byte[] b = JSONSerialiser.serialise(test, (String[])new String[0]);
        ParameterisedTestObject o = (ParameterisedTestObject)JSONSerialiser.deserialise((byte[])b, ParameterisedTestObject.class);
        Assert.assertEquals(ParameterisedTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)o.getX());
        Assert.assertEquals(Integer.class, o.getK().getClass());
        Assert.assertEquals((Object)2, o.getK());
    }

    @Test(expected=SerialisationException.class)
    public void testParameterisedDeserialisationOfComplexObjectToIncorrectType() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("Test");
        byte[] b = JSONSerialiser.serialise((Object)test, (String[])new String[0]);
        JSONSerialiser.deserialise((byte[])b, Integer.class);
    }

    @Test
    public void shouldSerialiseObjectWithoutFieldX() throws Exception {
        SimpleTestObject obj = new SimpleTestObject();
        String json = new String(JSONSerialiser.serialise((Object)obj, (String[])new String[]{"x"}), "UTF-8");
        Assert.assertFalse((boolean)json.contains("x"));
    }

    @Test
    public void shouldSerialiseObjectWithFieldX() throws Exception {
        SimpleTestObject obj = new SimpleTestObject();
        String json = new String(JSONSerialiser.serialise((Object)obj, (String[])new String[0]), "UTF-8");
        Assert.assertTrue((boolean)json.contains("x"));
    }

    @Test
    public void shouldSerialiseWithHistoricValues() throws Exception {
        Assert.assertNotNull(this.historicSerialisationPairs);
        for (Pair<Object, byte[]> pair : this.historicSerialisationPairs) {
            this.serialiseFirst(pair);
            this.deserialiseSecond(pair);
        }
    }

    @Test
    public void shouldThrowExceptionWhenUpdateInstanceWithInvalidClassName() throws Exception {
        System.setProperty("gaffer.serialiser.json.class", "invalidClassName");
        try {
            JSONSerialiser.update();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("invalidClassName"));
        }
    }

    @Test
    public void shouldThrowExceptionWhenUpdateInstanceWithInvalidModuleClass() throws Exception {
        System.setProperty("gaffer.serialiser.json.modules", "module1");
        try {
            JSONSerialiser.update();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("module1"));
        }
    }

    @Test
    public void shouldThrowExceptionWhenUpdateInstanceWithInvalidModulesValue() throws Exception {
        String invalidValue = TestCustomJsonModules1.class.getName() + "-" + TestCustomJsonModules2.class.getName();
        System.setProperty("gaffer.serialiser.json.modules", invalidValue);
        try {
            JSONSerialiser.update();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(invalidValue));
        }
    }

    @Test
    public void shouldUpdateInstanceWithCustomSerialiser() throws Exception {
        TestCustomJsonSerialiser1.mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        System.setProperty("gaffer.serialiser.json.class", TestCustomJsonSerialiser1.class.getName());
        JSONSerialiser.update();
        Assert.assertEquals(TestCustomJsonSerialiser1.class, JSONSerialiser.getInstance().getClass());
        Assert.assertSame((Object)TestCustomJsonSerialiser1.mapper, (Object)JSONSerialiser.getMapper());
    }

    @Test
    public void shouldUpdateInstanceWithCustomModule() throws Exception {
        JsonSerializer serialiser = (JsonSerializer)Mockito.mock(JsonSerializer.class);
        TestCustomJsonModules1.modules = Collections.singletonList(new SimpleModule("module1", new Version(1, 0, 0, null, null, null)).addSerializer(String.class, serialiser));
        System.setProperty("gaffer.serialiser.json.modules", TestCustomJsonModules1.class.getName());
        JSONSerialiser.update();
        Assert.assertEquals(JSONSerialiser.class, JSONSerialiser.getInstance().getClass());
        JSONSerialiser.serialise((Object)"test", (String[])new String[0]);
        ((JsonSerializer)Mockito.verify((Object)serialiser)).serialize(Mockito.eq((Object)"test"), (JsonGenerator)Mockito.any(), (SerializerProvider)Mockito.any());
    }

    @Test
    public void shouldUpdateInstanceWithCustomProperties() throws Exception {
        TestCustomJsonSerialiser1.mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        System.setProperty("gaffer.serialiser.json.class", TestCustomJsonSerialiser1.class.getName());
        TestCustomJsonModules1.modules = Arrays.asList((Module)Mockito.mock(Module.class), (Module)Mockito.mock(Module.class));
        TestCustomJsonModules2.modules = Arrays.asList((Module)Mockito.mock(Module.class), (Module)Mockito.mock(Module.class));
        System.setProperty("gaffer.serialiser.json.modules", TestCustomJsonModules1.class.getName() + "," + TestCustomJsonModules2.class.getName());
        System.setProperty("gaffer.serialiser.json.strict", "false");
        JSONSerialiser.update();
        Assert.assertEquals(TestCustomJsonSerialiser1.class, JSONSerialiser.getInstance().getClass());
        Assert.assertSame((Object)TestCustomJsonSerialiser1.mapper, (Object)JSONSerialiser.getMapper());
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper)).registerModules(TestCustomJsonModules1.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper)).registerModules(TestCustomJsonModules2.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Test
    public void shouldUpdateInstanceTwiceWithCustomProperties() throws Exception {
        TestCustomJsonSerialiser1.mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        TestCustomJsonSerialiser2.mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        TestCustomJsonModules1.modules = Arrays.asList((Module)Mockito.mock(Module.class), (Module)Mockito.mock(Module.class));
        TestCustomJsonModules2.modules = Arrays.asList((Module)Mockito.mock(Module.class), (Module)Mockito.mock(Module.class));
        JSONSerialiser.update((String)TestCustomJsonSerialiser1.class.getName(), (String)TestCustomJsonModules1.class.getName(), (Boolean)false);
        Assert.assertEquals(TestCustomJsonSerialiser1.class, JSONSerialiser.getInstance().getClass());
        Assert.assertSame((Object)TestCustomJsonSerialiser1.mapper, (Object)JSONSerialiser.getMapper());
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper)).registerModules(TestCustomJsonModules1.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper, (VerificationMode)Mockito.never())).registerModules(TestCustomJsonModules2.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser1.mapper)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSONSerialiser.update((String)TestCustomJsonSerialiser2.class.getName(), (String)TestCustomJsonModules2.class.getName(), (Boolean)true);
        Assert.assertEquals(TestCustomJsonSerialiser2.class, JSONSerialiser.getInstance().getClass());
        Assert.assertSame((Object)TestCustomJsonSerialiser2.mapper, (Object)JSONSerialiser.getMapper());
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser2.mapper)).registerModules(TestCustomJsonModules1.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser2.mapper)).registerModules(TestCustomJsonModules2.modules);
        ((ObjectMapper)Mockito.verify((Object)TestCustomJsonSerialiser2.mapper)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    @Test
    public void shouldDeserialiseClassWithUnknownFields() throws Exception {
        JSONSerialiser.update(null, null, (Boolean)false);
        TestPojo pojo = (TestPojo)JSONSerialiser.deserialise((String)"{\"field\": \"value\", \"unknown\": \"otherValue\"}", TestPojo.class);
        Assert.assertEquals((Object)"value", (Object)pojo.field);
    }

    @Test
    public void shouldThrowExceptionWhenDeserialiseClassWithUnknownFieldsWhenStrict() {
        JSONSerialiser.update(null, null, (Boolean)true);
        try {
            JSONSerialiser.deserialise((String)"{\"field\": \"value\", \"unknown\": \"otherValue\"}", TestPojo.class);
            Assert.fail((String)"Exception expected");
        }
        catch (SerialisationException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Unrecognized field \"unknown\""));
        }
    }

    protected void deserialiseSecond(Pair<Object, byte[]> pair) throws SerialisationException {
        Assert.assertEquals((Object)pair.getFirst(), (Object)JSONSerialiser.deserialise((byte[])((byte[])pair.getSecond()), pair.getFirst().getClass()));
    }

    protected void serialiseFirst(Pair<Object, byte[]> pair) throws SerialisationException {
        byte[] serialise = JSONSerialiser.serialise((Object)pair.getFirst(), (String[])new String[0]);
        Assert.assertArrayEquals((byte[])((byte[])pair.getSecond()), (byte[])serialise);
    }

    private static final class TestPojo {
        public String field;

        private TestPojo() {
        }
    }

    public static final class TestCustomJsonModules2
    implements JSONSerialiserModules {
        public static List<Module> modules;

        public List<Module> getModules() {
            return modules;
        }
    }

    public static final class TestCustomJsonModules1
    implements JSONSerialiserModules {
        public static List<Module> modules;

        public List<Module> getModules() {
            return modules;
        }
    }

    public static final class TestCustomJsonSerialiser2
    extends JSONSerialiser {
        public static ObjectMapper mapper;

        public TestCustomJsonSerialiser2() {
            super(mapper);
        }
    }

    public static final class TestCustomJsonSerialiser1
    extends JSONSerialiser {
        public static ObjectMapper mapper;

        public TestCustomJsonSerialiser1() {
            super(mapper);
        }
    }
}

