/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.DateSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;

public class DateSerialiserTest
extends ToBytesSerialisationTest<Date> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (long i = 121231232L; i < 121232232L; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)new Date(i));
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Date.class, o.getClass());
            Assert.assertEquals((Object)new Date(i), (Object)o);
        }
    }

    @Test
    public void canSerialiseEpoch() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)new Date(0L));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Date.class, o.getClass());
        Assert.assertEquals((Object)new Date(0L), (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseDateClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Date.class));
    }

    @Override
    public Serialiser getSerialisation() {
        return new DateSerialiser();
    }

    @Override
    public Pair<Date, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)new Date(60460074000000L), (Object)new byte[]{54, 48, 52, 54, 48, 48, 55, 52, 48, 48, 48, 48, 48, 48}), new Pair((Object)new Date(61406234880000L), (Object)new byte[]{54, 49, 52, 48, 54, 50, 51, 52, 56, 56, 48, 48, 48, 48}), new Pair((Object)new Date(59514676680000L), (Object)new byte[]{53, 57, 53, 49, 52, 54, 55, 54, 54, 56, 48, 48, 48, 48})};
    }
}

