/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.DoubleSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;

public class DoubleSerialiserTest
extends ToBytesSerialisationTest<Double> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (double i = 0.0; i < 1000.0; i += 1.1) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Double.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseDoubleMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseDoubleMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseDoubleClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Double.class));
    }

    @Override
    public Serialiser getSerialisation() {
        return new DoubleSerialiser();
    }

    @Override
    public Pair<Double, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Double.MAX_VALUE, (Object)new byte[]{49, 46, 55, 57, 55, 54, 57, 51, 49, 51, 52, 56, 54, 50, 51, 49, 53, 55, 69, 51, 48, 56}), new Pair((Object)Double.MIN_VALUE, (Object)new byte[]{52, 46, 57, 69, 45, 51, 50, 52}), new Pair((Object)0.0, (Object)new byte[]{48, 46, 48}), new Pair((Object)1.0, (Object)new byte[]{49, 46, 48})};
    }
}

