/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.FloatSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;

public class FloatSerialiserTest
extends ToBytesSerialisationTest<Float> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (float i = 0.0f; i < 1000.0f; i += 1.1f) {
            byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(i));
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Float.class, o.getClass());
            Assert.assertEquals((Object)Float.valueOf(i), (Object)o);
        }
    }

    @Test
    public void canSerialiseFloatMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MIN_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)o);
    }

    @Test
    public void canSerialiseFloatMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MAX_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseFloatClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Float.class));
    }

    @Override
    public Serialiser getSerialisation() {
        return new FloatSerialiser();
    }

    @Override
    public Pair<Float, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Float.valueOf(Float.MAX_VALUE), (Object)new byte[]{51, 46, 52, 48, 50, 56, 50, 51, 53, 69, 51, 56}), new Pair((Object)Float.valueOf(Float.MIN_VALUE), (Object)new byte[]{49, 46, 52, 69, 45, 52, 53}), new Pair((Object)Float.valueOf(0.0f), (Object)new byte[]{48, 46, 48}), new Pair((Object)Float.valueOf(1.0f), (Object)new byte[]{49, 46, 48})};
    }
}

