/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.IntegerSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;

public class IntegerSerialiserTest
extends ToBytesSerialisationTest<Integer> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (int i = 0; i < 1000; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Integer.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseIntegerMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseIntegerMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseIntegerClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Integer.class));
    }

    @Override
    public Serialiser<Integer, byte[]> getSerialisation() {
        return new IntegerSerialiser();
    }

    @Override
    public Pair<Integer, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Integer.MAX_VALUE, (Object)new byte[]{50, 49, 52, 55, 52, 56, 51, 54, 52, 55}), new Pair((Object)Integer.MIN_VALUE, (Object)new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56}), new Pair((Object)0, (Object)new byte[]{48}), new Pair((Object)1, (Object)new byte[]{49})};
    }
}

