/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.LongSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;

public class LongSerialiserTest
extends ToBytesSerialisationTest<Long> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (long i = 0L; i < 1000L; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Long.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseLongMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Long.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Long.class, o.getClass());
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseLongMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Long.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Long.class, o.getClass());
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseLongClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Long.class));
    }

    @Override
    public Serialiser<Long, byte[]> getSerialisation() {
        return new LongSerialiser();
    }

    @Override
    public Pair<Long, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Long.MAX_VALUE, (Object)new byte[]{57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 55}), new Pair((Object)Long.MIN_VALUE, (Object)new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56}), new Pair((Object)0L, (Object)new byte[]{48}), new Pair((Object)1L, (Object)new byte[]{49})};
    }
}

