/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;

public abstract class SerialisationTest<INPUT, OUTPUT> {
    protected final Serialiser<INPUT, OUTPUT> serialiser = this.getSerialisation();
    protected final Pair<INPUT, OUTPUT>[] historicSerialisationPairs = this.getHistoricSerialisationPairs();

    @Test
    public void shouldSerialiseWithHistoricValues() throws Exception {
        Assert.assertNotNull((String)"historicSerialisationPairs should not be null.", this.historicSerialisationPairs);
        Assert.assertNotEquals((String)"historicSerialisationPairs should not be empty.", (long)0L, (long)this.historicSerialisationPairs.length);
        for (Pair<INPUT, OUTPUT> pair : this.historicSerialisationPairs) {
            Assert.assertNotNull((String)"historicSerialisationPairs first value should not be null", (Object)pair.getFirst());
            this.serialiseFirst(pair);
            Assert.assertNotNull((String)"historicSerialisationPairs second value should not be null", (Object)pair.getSecond());
            this.deserialiseSecond(pair);
        }
    }

    protected void deserialiseSecond(Pair<INPUT, OUTPUT> pair) throws SerialisationException {
        Assert.assertEquals((Object)pair.getFirst(), (Object)this.serialiser.deserialise(pair.getSecond()));
    }

    protected void serialiseFirst(Pair<INPUT, OUTPUT> pair) throws SerialisationException {
        Assert.assertEquals((Object)pair.getSecond(), (Object)this.serialiser.serialise(pair.getFirst()));
    }

    @Test
    public abstract void shouldSerialiseNull() throws SerialisationException;

    @Test
    public abstract void shouldDeserialiseEmpty() throws SerialisationException;

    public abstract Serialiser<INPUT, OUTPUT> getSerialisation();

    public abstract Pair<INPUT, OUTPUT>[] getHistoricSerialisationPairs();
}

