/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.SerialisationTest;

public abstract class ToBytesSerialisationTest<T>
extends SerialisationTest<T, byte[]> {
    @Override
    public void shouldSerialiseNull() throws SerialisationException {
        byte[] bytes = (byte[])this.serialiser.serialiseNull();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])bytes);
    }

    @Override
    @Test
    public void shouldDeserialiseEmpty() throws SerialisationException {
        Assert.assertNull((Object)this.serialiser.deserialiseEmpty());
    }

    @Override
    protected void serialiseFirst(Pair<T, byte[]> pair) throws SerialisationException {
        byte[] serialise = (byte[])this.serialiser.serialise(pair.getFirst());
        Assert.assertArrayEquals((String)Arrays.toString(serialise), (byte[])((byte[])pair.getSecond()), (byte[])serialise);
    }
}

