/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.BytesSerialiser;

public class BytesSerialiserTest
extends ToBytesSerialisationTest<byte[]> {
    @Test
    public void cantSerialiseLongClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(Long.class));
    }

    @Test
    public void canSerialiseByteArrayClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(byte[].class));
    }

    @Test
    public void shouldSerialiseBytesByJustReturningTheProvidedBytes() throws SerialisationException {
        byte[] bytes = new byte[]{0, 1};
        byte[] serialisedBytes = (byte[])this.serialiser.serialise((Object)bytes);
        Assert.assertSame((Object)bytes, (Object)serialisedBytes);
    }

    @Test
    public void shouldDeerialiseBytesByJustReturningTheProvidedBytes() throws SerialisationException {
        byte[] bytes = new byte[]{0, 1};
        byte[] deserialisedBytes = (byte[])this.serialiser.deserialise((Object)bytes);
        Assert.assertSame((Object)bytes, (Object)deserialisedBytes);
    }

    @Override
    @Test
    public void shouldDeserialiseEmpty() throws SerialisationException {
        byte[] value = (byte[])this.serialiser.deserialiseEmpty();
        Assert.assertEquals((long)0L, (long)value.length);
    }

    @Override
    public Serialiser<byte[], byte[]> getSerialisation() {
        return new BytesSerialiser();
    }

    @Override
    public Pair<byte[], byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)new byte[]{1, 2, 3, 4, 5, 6}, (Object)new byte[]{1, 2, 3, 4, 5, 6}), new Pair((Object)new byte[]{12, 31, 43}, (Object)new byte[]{12, 31, 43}), new Pair((Object)new byte[0], (Object)new byte[0]), new Pair((Object)new byte[]{122, -111, -33}, (Object)new byte[]{122, -111, -33})};
    }

    @Override
    protected void deserialiseSecond(Pair<byte[], byte[]> pair) throws SerialisationException {
        Assert.assertArrayEquals((byte[])((byte[])pair.getFirst()), (byte[])((byte[])this.serialiser.deserialise(pair.getSecond())));
    }
}

