/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ParameterisedTestObject;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.SimpleTestObject;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.JavaSerialiser;

public class JavaSerialiserTest
extends ToBytesSerialisationTest<Object> {
    @Test
    public void testPrimitiveSerialisation() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)2);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void canHandleUnParameterisedDAO() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(SimpleTestObject.class));
    }

    @Test
    public void testDAOSerialisation() throws SerialisationException {
        SimpleTestObject test = new SimpleTestObject();
        test.setX("Test");
        byte[] b = (byte[])this.serialiser.serialise((Object)test);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(SimpleTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)((SimpleTestObject)o).getX());
    }

    @Test
    public void canHandleParameterisedDAO() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(ParameterisedTestObject.class));
    }

    @Test
    public void testParameterisedDAOSerialisation() throws SerialisationException {
        ParameterisedTestObject<Integer> test = new ParameterisedTestObject<Integer>();
        test.setX("Test");
        test.setK(2);
        byte[] b = (byte[])this.serialiser.serialise(test);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(ParameterisedTestObject.class, o.getClass());
        Assert.assertEquals((Object)"Test", (Object)((ParameterisedTestObject)o).getX());
        Assert.assertEquals(Integer.class, ((ParameterisedTestObject)o).getK().getClass());
        Assert.assertEquals((Object)2, ((ParameterisedTestObject)o).getK());
    }

    @Override
    public Serialiser<Object, byte[]> getSerialisation() {
        return new JavaSerialiser();
    }

    @Override
    public Pair<Object, byte[]>[] getHistoricSerialisationPairs() {
        HashMap map = Maps.newHashMap();
        map.put("this is a string in key", 123);
        map.put(456, "This is a string in value");
        return new Pair[]{new Pair((Object)map, (Object)new byte[]{-84, -19, 0, 5, 115, 114, 0, 17, 106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 72, 97, 115, 104, 77, 97, 112, 5, 7, -38, -63, -61, 22, 96, -47, 3, 0, 2, 70, 0, 10, 108, 111, 97, 100, 70, 97, 99, 116, 111, 114, 73, 0, 9, 116, 104, 114, 101, 115, 104, 111, 108, 100, 120, 112, 63, 64, 0, 0, 0, 0, 0, 12, 119, 8, 0, 0, 0, 16, 0, 0, 0, 2, 115, 114, 0, 17, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 73, 110, 116, 101, 103, 101, 114, 18, -30, -96, -92, -9, -127, -121, 56, 2, 0, 1, 73, 0, 5, 118, 97, 108, 117, 101, 120, 114, 0, 16, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 78, 117, 109, 98, 101, 114, -122, -84, -107, 29, 11, -108, -32, -117, 2, 0, 0, 120, 112, 0, 0, 1, -56, 116, 0, 25, 84, 104, 105, 115, 32, 105, 115, 32, 97, 32, 115, 116, 114, 105, 110, 103, 32, 105, 110, 32, 118, 97, 108, 117, 101, 116, 0, 23, 116, 104, 105, 115, 32, 105, 115, 32, 97, 32, 115, 116, 114, 105, 110, 103, 32, 105, 110, 32, 107, 101, 121, 115, 113, 0, 126, 0, 2, 0, 0, 0, 123, 120})};
    }
}

