/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.IntegerSerialiser;
import uk.gov.gchq.gaffer.serialisation.LongSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.MapSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.StringSerialiser;

public class MapSerialiserTest
extends ToBytesSerialisationTest<Map<? extends Object, ? extends Object>> {
    @Test
    public void shouldSerialiseAndDeSerialiseOverlappingMapValuesWithDifferentKeys() throws SerialisationException {
        Map<String, Long> map = this.getExampleValue();
        byte[] b = (byte[])this.serialiser.serialise(map);
        Map o = (Map)this.serialiser.deserialise((Object)b);
        Assert.assertEquals(HashMap.class, o.getClass());
        Assert.assertEquals((long)6L, (long)o.size());
        Assert.assertEquals(map, (Object)o);
        Assert.assertEquals((Object)123298333L, o.get("one"));
        Assert.assertEquals((Object)342903339L, o.get("two"));
        Assert.assertEquals((Object)123298333L, o.get("three"));
        Assert.assertEquals((Object)345353439L, o.get("four"));
        Assert.assertEquals((Object)123338333L, o.get("five"));
        Assert.assertEquals((Object)345353439L, o.get("six"));
    }

    private Map<String, Long> getExampleValue() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("one", 123298333L);
        map.put("two", 342903339L);
        map.put("three", 123298333L);
        map.put("four", 345353439L);
        map.put("five", 123338333L);
        map.put("six", 345353439L);
        return map;
    }

    @Test
    public void mapSerialiserTest() throws SerialisationException {
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
        map.put(1, 3);
        map.put(2, 7);
        map.put(3, 11);
        ((MapSerialiser)this.serialiser).setKeySerialiser((ToBytesSerialiser)new IntegerSerialiser());
        ((MapSerialiser)this.serialiser).setValueSerialiser((ToBytesSerialiser)new IntegerSerialiser());
        ((MapSerialiser)this.serialiser).setMapClass(LinkedHashMap.class);
        byte[] b = (byte[])this.serialiser.serialise(map);
        Map o = (Map)this.serialiser.deserialise((Object)b);
        Assert.assertEquals(LinkedHashMap.class, o.getClass());
        Assert.assertEquals((long)3L, (long)o.size());
        Assert.assertEquals((Object)3, o.get(1));
        Assert.assertEquals((Object)7, o.get(2));
        Assert.assertEquals((Object)11, o.get(3));
    }

    @Override
    public Serialiser<Map<? extends Object, ? extends Object>, byte[]> getSerialisation() {
        MapSerialiser serialiser = new MapSerialiser();
        serialiser.setKeySerialiser((ToBytesSerialiser)new StringSerialiser());
        serialiser.setValueSerialiser((ToBytesSerialiser)new LongSerialiser());
        return serialiser;
    }

    @Override
    public Pair<Map<? extends Object, ? extends Object>, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair(this.getExampleValue(), (Object)new byte[]{3, 115, 105, 120, 9, 51, 52, 53, 51, 53, 51, 52, 51, 57, 4, 102, 111, 117, 114, 9, 51, 52, 53, 51, 53, 51, 52, 51, 57, 3, 111, 110, 101, 9, 49, 50, 51, 50, 57, 56, 51, 51, 51, 3, 116, 119, 111, 9, 51, 52, 50, 57, 48, 51, 51, 51, 57, 5, 116, 104, 114, 101, 101, 9, 49, 50, 51, 50, 57, 56, 51, 51, 51, 4, 102, 105, 118, 101, 9, 49, 50, 51, 51, 51, 56, 51, 51, 51})};
    }
}

