/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.StreamUtil;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.core.exception.GafferCheckedException;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.jsonserialisation.JSONSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.MultiSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.StringSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawIntegerSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawLongSerialiser;

public class MultiSerialiserTest
extends ToBytesSerialisationTest<Object> {
    private static final String path = "multiSerialiser.json";

    @Override
    public Serialiser<Object, byte[]> getSerialisation() {
        MultiSerialiser multiSerialiser;
        try {
            multiSerialiser = (MultiSerialiser)JSONSerialiser.deserialise((InputStream)StreamUtil.openStream(this.getClass(), (String)path), MultiSerialiser.class);
        }
        catch (SerialisationException e) {
            throw new RuntimeException(e);
        }
        return multiSerialiser;
    }

    @Override
    public Pair<Object, byte[]>[] getHistoricSerialisationPairs() {
        Pair[] pairs = new Pair[]{new Pair((Object)"hello world", (Object)new byte[]{0, 104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100}), new Pair((Object)420L, (Object)new byte[]{1, -114, 1, -92})};
        return pairs;
    }

    @Test
    public void shouldAcceptSupportedSerialisers() throws Exception {
        MultiSerialiser multiSerialiser = new MultiSerialiser();
        multiSerialiser.setSerialisers(null);
    }

    @Test
    public void shouldMatchHistoricalSerialisation() throws IOException, GafferCheckedException {
        String fromDisk = IOUtils.readLines((InputStream)StreamUtil.openStream(this.getClass(), (String)path)).stream().collect(Collectors.joining("\n"));
        MultiSerialiser multiSerialiser = new MultiSerialiser().addSerialiser((byte)0, (ToBytesSerialiser)new StringSerialiser(), String.class).addSerialiser((byte)1, (ToBytesSerialiser)new CompactRawLongSerialiser(), Long.class).addSerialiser((byte)2, (ToBytesSerialiser)new CompactRawIntegerSerialiser(), Integer.class);
        String fromCode = new String(JSONSerialiser.serialise((Object)multiSerialiser, (boolean)true, (String[])new String[0]));
        Assert.assertEquals((Object)fromDisk, (Object)fromCode);
    }

    @Test
    public void shouldNotAddMultiSerialiser() {
        try {
            new MultiSerialiser().addSerialiser((byte)0, (ToBytesSerialiser)new MultiSerialiser(), Object.class);
            Assert.fail((String)"exception not thrown");
        }
        catch (GafferCheckedException e) {
            Assert.assertEquals((Object)"Adding nested MultiSerialiser within a MultiSerialiser is not supported yet.", (Object)e.getMessage());
        }
    }
}

