/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.NullSerialiser;

public class NullSerialiserTest
extends ToBytesSerialisationTest<Object> {
    @Override
    public Serialiser<Object, byte[]> getSerialisation() {
        return new NullSerialiser();
    }

    @Override
    public Pair<Object, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)"", (Object)new byte[0]), new Pair(null, (Object)new byte[0]), new Pair((Object)"some string", (Object)new byte[0]), new Pair((Object)1L, (Object)new byte[0]), new Pair((Object)0, (Object)new byte[0]), new Pair((Object)true, (Object)new byte[0]), new Pair((Object)false, (Object)new byte[0])};
    }

    @Override
    @Test
    public void shouldDeserialiseEmpty() throws SerialisationException {
        Assert.assertNull((Object)this.serialiser.deserialiseEmpty());
    }

    @Test
    public void shouldHandleAnyClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(String.class));
        Assert.assertTrue((boolean)this.serialiser.canHandle(Object.class));
        Assert.assertTrue((boolean)this.serialiser.canHandle(Integer.class));
    }

    @Test
    public void shouldBeConsistent() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.isConsistent());
    }

    @Test
    public void shouldPreserveOrdering() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.preservesObjectOrdering());
    }

    @Override
    public void shouldSerialiseWithHistoricValues() throws Exception {
        for (Pair pair : this.historicSerialisationPairs) {
            this.serialiseFirst(pair);
            Assert.assertNull((Object)this.serialiser.deserialise(pair.getSecond()));
        }
    }
}

