/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.IntegerSerialiser;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.SetSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.StringSerialiser;

public class SetSerialiserTest
extends ToBytesSerialisationTest<Set<? extends Object>> {
    @Test
    public void shouldSerialiseAndDeSerialiseSet() throws SerialisationException {
        Set<String> set = this.getExampleValue();
        byte[] b = (byte[])this.serialiser.serialise(set);
        Set o = (Set)this.serialiser.deserialise((Object)b);
        Assert.assertEquals(HashSet.class, o.getClass());
        Assert.assertEquals((long)6L, (long)o.size());
        Assert.assertEquals(set, (Object)o);
        Assert.assertTrue((boolean)o.contains("one"));
        Assert.assertTrue((boolean)o.contains("two"));
        Assert.assertTrue((boolean)o.contains("three"));
        Assert.assertTrue((boolean)o.contains("four"));
        Assert.assertTrue((boolean)o.contains("five"));
        Assert.assertTrue((boolean)o.contains("six"));
    }

    private Set<String> getExampleValue() {
        HashSet<String> set = new HashSet<String>();
        set.add("one");
        set.add("two");
        set.add("three");
        set.add("four");
        set.add("five");
        set.add("six");
        return set;
    }

    @Test
    public void setSerialiserWithOverlappingValuesTest() throws SerialisationException {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        set.add(1);
        set.add(3);
        set.add(2);
        set.add(7);
        set.add(3);
        set.add(11);
        ((SetSerialiser)this.serialiser).setObjectSerialiser((ToBytesSerialiser)new IntegerSerialiser());
        ((SetSerialiser)this.serialiser).setSetClass(LinkedHashSet.class);
        byte[] b = (byte[])this.serialiser.serialise(set);
        Set o = (Set)this.serialiser.deserialise((Object)b);
        Assert.assertEquals(LinkedHashSet.class, o.getClass());
        Assert.assertEquals((long)5L, (long)o.size());
        Assert.assertTrue((boolean)o.contains(1));
        Assert.assertTrue((boolean)o.contains(3));
        Assert.assertTrue((boolean)o.contains(2));
        Assert.assertTrue((boolean)o.contains(7));
        Assert.assertTrue((boolean)o.contains(11));
    }

    @Override
    public Serialiser<Set<? extends Object>, byte[]> getSerialisation() {
        SetSerialiser serialiser = new SetSerialiser();
        serialiser.setObjectSerialiser((ToBytesSerialiser)new StringSerialiser());
        return serialiser;
    }

    @Override
    public Pair<Set<? extends Object>, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair(this.getExampleValue(), (Object)new byte[]{3, 115, 105, 120, 4, 102, 111, 117, 114, 3, 111, 110, 101, 3, 116, 119, 111, 5, 116, 104, 114, 101, 101, 4, 102, 105, 118, 101})};
    }

    @Override
    @Test
    public void shouldDeserialiseEmpty() throws SerialisationException {
        Assert.assertEquals(new HashSet(), (Object)this.serialiser.deserialiseEmpty());
    }
}

