/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.StringSerialiser;

public class StringSerialiserTest
extends ToBytesSerialisationTest<String> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append(i);
            byte[] b = (byte[])this.serialiser.serialise((Object)builder.toString());
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(String.class, o.getClass());
            Assert.assertEquals((Object)builder.toString(), (Object)o);
        }
    }

    @Test
    public void cantSerialiseLongClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(Long.class));
    }

    @Test
    public void canSerialiseStringClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(String.class));
    }

    @Override
    public void shouldDeserialiseEmpty() throws SerialisationException {
        String value = (String)this.serialiser.deserialiseEmpty();
        Assert.assertEquals((Object)"", (Object)value);
    }

    @Override
    public Serialiser<String, byte[]> getSerialisation() {
        return new StringSerialiser();
    }

    @Override
    public Pair<String, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)"This is a test String ", (Object)new byte[]{84, 104, 105, 115, 32, 105, 115, 32, 97, 32, 116, 101, 115, 116, 32, 83, 116, 114, 105, 110, 103, 32}), new Pair((Object)"! @ # $ % ^ & * ( ) *  _ + { } [ ] ; : ' \\ | < , > . / ? ` ~", (Object)new byte[]{33, 32, 64, 32, 35, 32, 36, 32, 37, 32, 94, 32, 38, 32, 42, 32, 40, 32, 41, 32, 42, 32, 32, 95, 32, 43, 32, 123, 32, 125, 32, 91, 32, 93, 32, 59, 32, 58, 32, 39, 32, 92, 32, 124, 32, 60, 32, 44, 32, 62, 32, 46, 32, 47, 32, 63, 32, 96, 32, 126}), new Pair((Object)"\u0153 \u2211 \u00b4 \u2020 \u00a5 \u00a8 \u02c6 \u03c0 \u00e5 \u00df \u2202 \u0192 \u00a9 \u02d9 \u2206 \u02da \u00ac \u03a9\u2248 \u00e7 \u221a \u222b \u02dc  \u2264\u00a1 \u2122 \u00a3 \u00a2 \u221e \u00a7 \u00b6 \u2022 \u00aa \u00ba", (Object)new byte[]{-59, -109, 32, -30, -120, -111, 32, -62, -76, 32, -30, -128, -96, 32, -62, -91, 32, -62, -88, 32, -53, -122, 32, -49, -128, 32, -61, -91, 32, -61, -97, 32, -30, -120, -126, 32, -58, -110, 32, -62, -87, 32, -53, -103, 32, -30, -120, -122, 32, -53, -102, 32, -62, -84, 32, -50, -87, -30, -119, -120, 32, -61, -89, 32, -30, -120, -102, 32, -30, -120, -85, 32, -53, -100, 32, 32, -30, -119, -92, -62, -95, 32, -30, -124, -94, 32, -62, -93, 32, -62, -94, 32, -30, -120, -98, 32, -62, -89, 32, -62, -74, 32, -30, -128, -94, 32, -62, -86, 32, -62, -70})};
    }
}

