/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.TreeSetStringSerialiser;

public class TreeSetStringSerialiserTest
extends ToBytesSerialisationTest<TreeSet<String>> {
    @Test
    public void shouldSerialiseAndDeserialiseATreeSet() throws SerialisationException {
        TreeSet<String> set = new TreeSet<String>();
        set.add("string1");
        set.add("string2");
        set.add("string3");
        set.add("string4");
        byte[] serialisedSet = (byte[])this.serialiser.serialise(set);
        TreeSet deserialisedSet = (TreeSet)this.serialiser.deserialise((Object)serialisedSet);
        Assert.assertNotSame((Object)deserialisedSet, set);
        Assert.assertEquals((Object)deserialisedSet, set);
    }

    @Test
    public void shouldSerialiseAndDeserialiseAnEmptyTreeSet() throws SerialisationException {
        TreeSet set = new TreeSet();
        byte[] serialisedSet = (byte[])this.serialiser.serialise(set);
        TreeSet deserialisedSet = (TreeSet)this.serialiser.deserialise((Object)serialisedSet);
        Assert.assertNotSame((Object)deserialisedSet, set);
        Assert.assertEquals((Object)deserialisedSet, set);
    }

    @Test
    public void shouldBeAbleToHandleATreeSet() throws SerialisationException {
        Class<TreeSet> testClass = TreeSet.class;
        boolean canHandle = this.serialiser.canHandle(testClass);
        Assert.assertTrue((boolean)canHandle);
    }

    @Test
    public void shouldNotBeAbleToHandleAHashSet() throws SerialisationException {
        Class<HashSet> testClass = HashSet.class;
        boolean canHandle = this.serialiser.canHandle(testClass);
        Assert.assertFalse((boolean)canHandle);
    }

    @Override
    public Serialiser<TreeSet<String>, byte[]> getSerialisation() {
        return new TreeSetStringSerialiser();
    }

    @Override
    public void shouldDeserialiseEmpty() throws SerialisationException {
        TreeSet tree = (TreeSet)this.serialiser.deserialiseEmpty();
        Assert.assertNotNull((Object)tree);
        Assert.assertTrue((boolean)tree.isEmpty());
    }

    @Override
    public Pair<TreeSet<String>, byte[]>[] getHistoricSerialisationPairs() {
        TreeSet set = Sets.newTreeSet();
        set.add("this");
        set.add("is");
        set.add("S P A R T A!!!!!");
        return new Pair[]{new Pair((Object)set, (Object)new byte[]{123, 83, 32, 80, 32, 65, 32, 82, 32, 84, 32, 65, 33, 33, 33, 33, 33, 92, 44, 105, 115, 92, 44, 116, 104, 105, 115, 125})};
    }
}

