/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedDateSerialiser;

public class OrderedDateSerialiserTest
extends ToBytesSerialisationTest<Date> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (long i = 1000000L; i < 1001000L; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)new Date(i));
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Date.class, o.getClass());
            Assert.assertEquals((Object)new Date(i), (Object)o);
        }
    }

    @Test
    public void canSerialiseEpoch() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)new Date(0L));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Date.class, o.getClass());
        Assert.assertEquals((Object)new Date(0L), (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseDateClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Date.class));
    }

    @Test
    public void checkOrderPreserved() throws SerialisationException {
        Date testDate = new Date(1L);
        Date aDayLater = new Date(86400000L);
        Assert.assertTrue((OrderedDateSerialiserTest.compare((byte[])this.serialiser.serialise((Object)testDate), (byte[])this.serialiser.serialise((Object)aDayLater)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkMultipleDatesOrderPreserved() throws SerialisationException {
        Date startTestDate = new Date(1L);
        Long time = 2L;
        while (time > 10L) {
            Date newTestDate = new Date(time);
            Assert.assertTrue((OrderedDateSerialiserTest.compare((byte[])this.serialiser.serialise((Object)startTestDate), (byte[])this.serialiser.serialise((Object)newTestDate)) < 0 ? 1 : 0) != 0);
            startTestDate = newTestDate;
            Long l = time;
            Long l2 = time = Long.valueOf(time + 1L);
        }
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Serialiser<Date, byte[]> getSerialisation() {
        return new OrderedDateSerialiser();
    }

    @Override
    public Pair<Date, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)new Date(60460074000000L), (Object)new byte[]{8, -128, 0, 54, -4, -11, 59, -34, -128}), new Pair((Object)new Date(61406234880000L), (Object)new byte[]{8, -128, 0, 55, -39, 64, -47, 40, 0}), new Pair((Object)new Date(59514676680000L), (Object)new byte[]{8, -128, 0, 54, 32, -41, 41, -107, 64})};
    }
}

