/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedDoubleSerialiser;

public class OrderedDoubleSerialiserTest
extends ToBytesSerialisationTest<Double> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (double i = 0.0; i < 1000.0; i += 1.0) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Double.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseDoubleMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseDoubleMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)o);
    }

    @Test
    public void checkOrderPreserved() throws SerialisationException {
        byte[] startBytes = (byte[])this.serialiser.serialise((Object)0.0);
        Double test = 1.0;
        while (test >= 10.0) {
            byte[] newTestBytes = (byte[])this.serialiser.serialise((Object)test);
            Assert.assertTrue((OrderedDoubleSerialiserTest.compare(newTestBytes, startBytes) < 0 ? 1 : 0) != 0);
            startBytes = newTestBytes;
            Double d = test;
            Double d2 = test = Double.valueOf(test + 1.0);
        }
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseDoubleClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Double.class));
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Serialiser<Double, byte[]> getSerialisation() {
        return new OrderedDoubleSerialiser();
    }

    @Override
    public Pair<Double, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Double.MAX_VALUE, (Object)new byte[]{8, 127, -17, -1, -1, -1, -1, -1, -1}), new Pair((Object)Double.MIN_VALUE, (Object)new byte[]{1, 1}), new Pair((Object)0.0, (Object)new byte[]{0}), new Pair((Object)1.0, (Object)new byte[]{8, 63, -16, 0, 0, 0, 0, 0, 0})};
    }
}

