/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedFloatSerialiser;

public class OrderedFloatSerialiserTest
extends ToBytesSerialisationTest<Float> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        float i = 0.0f;
        while (i < 1000.0f) {
            byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(i));
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Float.class, o.getClass());
            Assert.assertEquals((Object)Float.valueOf(i), (Object)o);
            i = (float)((double)i + 1.1);
        }
    }

    @Test
    public void canSerialiseFloatMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MIN_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)o);
    }

    @Test
    public void canSerialiseFloatMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MAX_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)o);
    }

    @Test
    public void checkOrderPreserved() throws SerialisationException {
        byte[] startBytes = (byte[])this.serialiser.serialise((Object)Float.valueOf(0.0f));
        Float test = Float.valueOf(1.0f);
        while (test.floatValue() >= 5.0f) {
            byte[] newTestBytes = (byte[])this.serialiser.serialise((Object)test);
            Assert.assertTrue((OrderedFloatSerialiserTest.compare(newTestBytes, startBytes) < 0 ? 1 : 0) != 0);
            startBytes = newTestBytes;
            test = Float.valueOf(test.floatValue() + 0.1f);
        }
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseFloatClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Float.class));
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Serialiser<Float, byte[]> getSerialisation() {
        return new OrderedFloatSerialiser();
    }

    @Override
    public Pair<Float, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Float.valueOf(Float.MAX_VALUE), (Object)new byte[]{4, 127, 127, -1, -1}), new Pair((Object)Float.valueOf(Float.MIN_VALUE), (Object)new byte[]{1, 1}), new Pair((Object)Float.valueOf(0.0f), (Object)new byte[]{0}), new Pair((Object)Float.valueOf(1.0f), (Object)new byte[]{4, 63, -128, 0, 0})};
    }
}

