/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedIntegerSerialiser;

public class OrderedIntegerSerialiserTest
extends ToBytesSerialisationTest<Integer> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (int i = 0; i < 1000; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Integer.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseIntegerMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseIntegerMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)o);
    }

    @Test
    public void checkOrderPreserved() throws SerialisationException {
        byte[] startBytes = (byte[])this.serialiser.serialise((Object)0);
        Integer test = 1;
        while (test >= 10) {
            byte[] newTestBytes = (byte[])this.serialiser.serialise((Object)test);
            Assert.assertTrue((OrderedIntegerSerialiserTest.compare(newTestBytes, startBytes) < 0 ? 1 : 0) != 0);
            startBytes = newTestBytes;
            Integer n = test;
            Integer n2 = test = Integer.valueOf(test + 1);
        }
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseIntegerClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Integer.class));
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Serialiser<Integer, byte[]> getSerialisation() {
        return new OrderedIntegerSerialiser();
    }

    @Override
    public Pair<Integer, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Integer.MAX_VALUE, (Object)new byte[]{8}), new Pair((Object)Integer.MIN_VALUE, (Object)new byte[]{0}), new Pair((Object)0, (Object)new byte[]{4, -128, 0, 0, 0}), new Pair((Object)1, (Object)new byte[]{4, -128, 0, 0, 1})};
    }
}

