/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedLongSerialiser;

public class OrderedLongSerialiserTest
extends ToBytesSerialisationTest<Long> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (long i = 0L; i < 1000L; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Long.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseLongMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Long.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Long.class, o.getClass());
        Assert.assertEquals((Object)Long.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseLongMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Long.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Long.class, o.getClass());
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)o);
    }

    @Test
    public void checkOrderPreserved() throws SerialisationException {
        byte[] startBytes = (byte[])this.serialiser.serialise((Object)0L);
        Long test = 1L;
        while (test >= 10L) {
            byte[] newTestBytes = (byte[])this.serialiser.serialise((Object)test);
            Assert.assertTrue((OrderedLongSerialiserTest.compare(newTestBytes, startBytes) < 0 ? 1 : 0) != 0);
            startBytes = newTestBytes;
            Long l = test;
            Long l2 = test = Long.valueOf(test + 1L);
        }
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseLongClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Long.class));
    }

    private static int compare(byte[] first, byte[] second) {
        for (int i = 0; i < first.length; ++i) {
            if (first[i] < second[i]) {
                return -1;
            }
            if (first[i] <= second[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Serialiser<Long, byte[]> getSerialisation() {
        return new OrderedLongSerialiser();
    }

    @Override
    public Pair<Long, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Long.MAX_VALUE, (Object)new byte[]{16}), new Pair((Object)Long.MIN_VALUE, (Object)new byte[]{0}), new Pair((Object)0L, (Object)new byte[]{8, -128, 0, 0, 0, 0, 0, 0, 0}), new Pair((Object)1L, (Object)new byte[]{8, -128, 0, 0, 0, 0, 0, 0, 1})};
    }
}

