/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawIntegerSerialiser;

public class CompactRawIntegerSerialiserTest
extends ToBytesSerialisationTest<Integer> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (int i = 0; i < 1000; ++i) {
            this.test(i);
        }
    }

    @Test
    public void testCanSerialiseANegativeSampleRange() throws SerialisationException {
        for (int i = -1000; i < 0; ++i) {
            this.test(i);
        }
    }

    @Test
    public void canSerialiseIntegerMinValue() throws SerialisationException {
        this.test(Integer.MIN_VALUE);
    }

    @Test
    public void canSerialiseIntegerMaxValue() throws SerialisationException {
        this.test(Integer.MAX_VALUE);
    }

    @Test
    public void canSerialiseAllOrdersOfMagnitude() throws SerialisationException {
        for (int i = 0; i < 32; ++i) {
            int value = (int)Math.pow(2.0, i);
            this.test(value);
            this.test(-value);
        }
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseIntegerClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Integer.class));
    }

    private void test(int value) throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)value);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)value, (Object)o);
    }

    @Override
    public Serialiser<Integer, byte[]> getSerialisation() {
        return new CompactRawIntegerSerialiser();
    }

    @Override
    public Pair<Integer, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Integer.MAX_VALUE, (Object)new byte[]{-116, 127, -1, -1, -1}), new Pair((Object)Integer.MIN_VALUE, (Object)new byte[]{-124, 127, -1, -1, -1}), new Pair((Object)0, (Object)new byte[]{0}), new Pair((Object)1, (Object)new byte[]{1})};
    }
}

