/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawLongSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawSerialisationUtils;

public class CompactRawLongSerialiserTest
extends ToBytesSerialisationTest<Long> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (long i = 0L; i < 1000L; ++i) {
            this.test(i);
        }
    }

    @Test
    public void testCanSerialiseANegativeSampleRange() throws SerialisationException {
        for (long i = -1000L; i < 0L; ++i) {
            this.test(i);
        }
    }

    @Test
    public void canSerialiseLongMinValue() throws SerialisationException {
        this.test(Long.MIN_VALUE);
    }

    @Test
    public void canSerialiseLongMaxValue() throws SerialisationException {
        this.test(Long.MAX_VALUE);
    }

    @Test
    public void canSerialiseAllOrdersOfMagnitude() throws SerialisationException {
        for (int i = 0; i < 64; ++i) {
            long value = (long)Math.pow(2.0, i);
            this.test(value);
            this.test(-value);
        }
    }

    @Test
    public void cantSerialiseStringClass() {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseLongClass() {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Long.class));
    }

    private void test(long value) throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)value);
        Object o = ((ToBytesSerialiser)this.serialiser).deserialise(b, 0, b.length);
        Assert.assertEquals(Long.class, o.getClass());
        Assert.assertEquals((Object)value, (Object)o);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CompactRawSerialisationUtils.write((long)value, (OutputStream)new DataOutputStream((OutputStream)stream));
        long result = CompactRawSerialisationUtils.read((InputStream)new DataInputStream(new ByteArrayInputStream(stream.toByteArray())));
        Assert.assertEquals((long)result, (long)value);
    }

    @Override
    public Serialiser<Long, byte[]> getSerialisation() {
        return new CompactRawLongSerialiser();
    }

    @Override
    public Pair<Long, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Long.MAX_VALUE, (Object)new byte[]{-120, 127, -1, -1, -1, -1, -1, -1, -1}), new Pair((Object)Long.MIN_VALUE, (Object)new byte[]{-128, 127, -1, -1, -1, -1, -1, -1, -1}), new Pair((Object)0L, (Object)new byte[]{0}), new Pair((Object)1L, (Object)new byte[]{1})};
    }
}

