/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawSerialisationUtils;

public class CompactRawSerialisationUtilsTest {
    private static final String LONG_VALUE_IS_LEGAL_TO_NOT_REQUIRE_A_LENGTH_BYTE = "long value is legal to not require a length byte";
    private static final String LONG_VALUE_REQUIRES_A_LENGTH_BYTE = "long value requires a length byte";
    private static final String LENGTH_SHOULD_BE_1_AS_IT_DOES_NOT_REQUIRE_A_LENGTH_BYTE = "Length should be 1, as it does not require a length byte";
    private byte[] bytesWithLength;

    @Before
    public void setUp() throws Exception {
        this.bytesWithLength = new byte[]{-120, 17, 34, 16, -12, 125, -23, -127, 21};
    }

    @Test
    public void shouldHaveExtraByteForLengthInFieldVariables() throws Exception {
        Assert.assertEquals((long)9L, (long)this.bytesWithLength.length);
    }

    @Test
    public void shouldNotHaveExtraByteForLength() throws Exception {
        long lLowerLimit = -112L;
        long lUpperLimit = 127L;
        byte[] bytesLower = CompactRawSerialisationUtils.writeLong((long)lLowerLimit);
        Assert.assertEquals((String)LONG_VALUE_IS_LEGAL_TO_NOT_REQUIRE_A_LENGTH_BYTE, (long)1L, (long)bytesLower.length);
        Assert.assertEquals((String)LONG_VALUE_IS_LEGAL_TO_NOT_REQUIRE_A_LENGTH_BYTE, (long)bytesLower.length, (long)CompactRawSerialisationUtils.decodeVIntSize((byte)bytesLower[0]));
        byte[] bytesUpper = CompactRawSerialisationUtils.writeLong((long)lUpperLimit);
        Assert.assertEquals((String)LENGTH_SHOULD_BE_1_AS_IT_DOES_NOT_REQUIRE_A_LENGTH_BYTE, (long)1L, (long)bytesUpper.length);
        Assert.assertEquals((String)LENGTH_SHOULD_BE_1_AS_IT_DOES_NOT_REQUIRE_A_LENGTH_BYTE, (long)bytesUpper.length, (long)CompactRawSerialisationUtils.decodeVIntSize((byte)bytesUpper[0]));
    }

    @Test
    public void shouldHaveExtraByteForLength() throws Exception {
        long lExceedLowerLimit = -113L;
        long lExceedUpperLimit = 128L;
        byte[] bytesLower = CompactRawSerialisationUtils.writeLong((long)lExceedLowerLimit);
        Assert.assertEquals((String)LONG_VALUE_REQUIRES_A_LENGTH_BYTE, (long)2L, (long)bytesLower.length);
        Assert.assertEquals((String)LONG_VALUE_REQUIRES_A_LENGTH_BYTE, (long)bytesLower.length, (long)CompactRawSerialisationUtils.decodeVIntSize((byte)bytesLower[0]));
        byte[] bytesUpper = CompactRawSerialisationUtils.writeLong((long)lExceedUpperLimit);
        Assert.assertNotEquals((String)"Length should not be 1, as it does require a length byte", (long)1L, (long)bytesUpper.length);
        Assert.assertEquals((long)bytesUpper.length, (long)CompactRawSerialisationUtils.decodeVIntSize((byte)bytesUpper[0]));
    }
}

