/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.RawDoubleSerialiser;

public class RawDoubleSerialiserTest
extends ToBytesSerialisationTest<Double> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (double i = 0.0; i < 1000.0; i += 1.1) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Double.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseDoubleMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseDoubleMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Double.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Double.class, o.getClass());
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseDoubleClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Double.class));
    }

    @Override
    public Serialiser<Double, byte[]> getSerialisation() {
        return new RawDoubleSerialiser();
    }

    @Override
    public Pair<Double, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Double.MAX_VALUE, (Object)new byte[]{-1, -1, -1, -1, -1, -1, -17, 127}), new Pair((Object)Double.MIN_VALUE, (Object)new byte[]{1, 0, 0, 0, 0, 0, 0, 0}), new Pair((Object)0.0, (Object)new byte[]{0, 0, 0, 0, 0, 0, 0, 0}), new Pair((Object)1.0, (Object)new byte[]{0, 0, 0, 0, 0, 0, -16, 63})};
    }
}

