/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.RawFloatSerialiser;

public class RawFloatSerialiserTest
extends ToBytesSerialisationTest<Float> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        float i = 0.0f;
        while (i < 1000.0f) {
            byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(i));
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Float.class, o.getClass());
            Assert.assertEquals((Object)Float.valueOf(i), (Object)o);
            i = (float)((double)i + 1.1);
        }
    }

    @Test
    public void canSerialiseFloatMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MIN_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)o);
    }

    @Test
    public void canSerialiseFloatMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Float.valueOf(Float.MAX_VALUE));
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Float.class, o.getClass());
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseFloatClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Float.class));
    }

    @Override
    public Serialiser<Float, byte[]> getSerialisation() {
        return new RawFloatSerialiser();
    }

    @Override
    public Pair<Float, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Float.valueOf(Float.MAX_VALUE), (Object)new byte[]{-1, -1, 127, 127}), new Pair((Object)Float.valueOf(Float.MIN_VALUE), (Object)new byte[]{1, 0, 0, 0}), new Pair((Object)Float.valueOf(0.0f), (Object)new byte[]{0, 0, 0, 0}), new Pair((Object)Float.valueOf(1.0f), (Object)new byte[]{0, 0, -128, 63})};
    }
}

