/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialisationTest;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.RawIntegerSerialiser;

public class RawIntegerSerialiserTest
extends ToBytesSerialisationTest<Integer> {
    @Test
    public void testCanSerialiseASampleRange() throws SerialisationException {
        for (int i = 0; i < 1000; ++i) {
            byte[] b = (byte[])this.serialiser.serialise((Object)i);
            Object o = this.serialiser.deserialise((Object)b);
            Assert.assertEquals(Integer.class, o.getClass());
            Assert.assertEquals((Object)i, (Object)o);
        }
    }

    @Test
    public void canSerialiseIntegerMinValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MIN_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)o);
    }

    @Test
    public void canSerialiseIntegerMaxValue() throws SerialisationException {
        byte[] b = (byte[])this.serialiser.serialise((Object)Integer.MAX_VALUE);
        Object o = this.serialiser.deserialise((Object)b);
        Assert.assertEquals(Integer.class, o.getClass());
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)o);
    }

    @Test
    public void cantSerialiseStringClass() throws SerialisationException {
        Assert.assertFalse((boolean)this.serialiser.canHandle(String.class));
    }

    @Test
    public void canSerialiseIntegerClass() throws SerialisationException {
        Assert.assertTrue((boolean)this.serialiser.canHandle(Integer.class));
    }

    @Override
    public Serialiser<Integer, byte[]> getSerialisation() {
        return new RawIntegerSerialiser();
    }

    @Override
    public Pair<Integer, byte[]>[] getHistoricSerialisationPairs() {
        return new Pair[]{new Pair((Object)Integer.MAX_VALUE, (Object)new byte[]{-1, -1, -1, 127}), new Pair((Object)Integer.MIN_VALUE, (Object)new byte[]{0, 0, 0, -128}), new Pair((Object)0, (Object)new byte[]{0, 0, 0, 0}), new Pair((Object)1, (Object)new byte[]{1, 0, 0, 0})};
    }
}

