/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.tostring;

import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.pair.Pair;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.SerialisationTest;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.tostring.StringToStringSerialiser;

public class StringToStringSerialiserTest
extends SerialisationTest<String, String> {
    public static final String STRING_VALUE_1 = "StringValue1";

    @Test
    public void shouldSerialiseAndDeserialise() throws Exception {
        String serialised = (String)this.serialiser.serialise((Object)STRING_VALUE_1);
        String deserialise = (String)this.serialiser.deserialise((Object)serialised);
        Assert.assertEquals((Object)STRING_VALUE_1, (Object)serialised);
        Assert.assertEquals((Object)STRING_VALUE_1, (Object)deserialise);
        Assert.assertEquals((Object)serialised, (Object)deserialise);
    }

    @Override
    public void shouldSerialiseNull() throws SerialisationException {
        Assert.assertNull((Object)this.serialiser.serialiseNull());
    }

    @Override
    public void shouldDeserialiseEmpty() throws SerialisationException {
        Assert.assertNull((Object)this.serialiser.serialiseNull());
    }

    @Override
    public Serialiser<String, String> getSerialisation() {
        return new StringToStringSerialiser();
    }

    @Override
    public Pair<String, String>[] getHistoricSerialisationPairs() {
        String s = "this is a string to be used for checking the serialisation.";
        return new Pair[]{new Pair((Object)s, (Object)s)};
    }
}

