/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.serialisation.util.JsonSerialisationUtil;
import uk.gov.gchq.koryphe.impl.predicate.IsIn;
import uk.gov.gchq.koryphe.impl.predicate.range.InDateRange;
import uk.gov.gchq.koryphe.impl.predicate.range.InRange;
import uk.gov.gchq.koryphe.impl.predicate.range.InTimeRange;

public class JsonSerialisationUtilTest {
    @Test
    public void testClassWithNoFields() {
        String className = ClassWithNoFields.class.getName();
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertTrue((boolean)result.entrySet().isEmpty());
    }

    @Test
    public void testClassWithJsonAnnotations() {
        String className = ClassWithAnnotations.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("field1", String.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testClassWithCreator() {
        String className = ClassWithCreator.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("field1", String.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testClassWithBuilder() {
        String className = ClassWithBuilder.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("field1", String.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testIsIn() {
        String className = IsIn.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("values", "java.lang.Object[]");
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testInRange() {
        String className = InRange.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("start", "java.lang.Comparable<T>");
        expectedValues.put("end", "java.lang.Comparable<T>");
        expectedValues.put("startInclusive", Boolean.class.getName());
        expectedValues.put("endInclusive", Boolean.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)className);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testInDateRangeAndInTimeRange() {
        String classNameIDR = InDateRange.class.getName();
        String classNameITR = InTimeRange.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("timeUnit", String.class.getName());
        expectedValues.put("offsetUnit", String.class.getName());
        expectedValues.put("start", String.class.getName());
        expectedValues.put("startOffset", Long.class.getName());
        expectedValues.put("startInclusive", Boolean.class.getName());
        expectedValues.put("end", String.class.getName());
        expectedValues.put("endOffset", Long.class.getName());
        expectedValues.put("endInclusive", Boolean.class.getName());
        expectedValues.put("timeZone", String.class.getName());
        Map resultIDR = JsonSerialisationUtil.getSerialisedFieldClasses((String)classNameIDR);
        Map resultITR = JsonSerialisationUtil.getSerialisedFieldClasses((String)classNameITR);
        Assert.assertEquals(expectedValues.entrySet(), resultIDR.entrySet());
        Assert.assertEquals(resultIDR.entrySet(), resultITR.entrySet());
    }

    @Test
    public void testClassWithTypeParamAndOtherField() {
        String ClassWithTypeParamAndOtherFieldName = ClassWithTypeParamAndOtherField.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("test", String.class.getName());
        expectedValues.put("t", Object.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)ClassWithTypeParamAndOtherFieldName);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testClassWithJustTypeParam() {
        String classWithTypeParamName = ClassWithTypeParam.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("t", Object.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)classWithTypeParamName);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    @Test
    public void testClassWithTypeParamExtendingComparable() {
        String ClassWithTypeParamExtendingComparableName = ClassWithTypeParamExtendingComparable.class.getName();
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put("t", Comparable.class.getName());
        Map result = JsonSerialisationUtil.getSerialisedFieldClasses((String)ClassWithTypeParamExtendingComparableName);
        Assert.assertEquals(expectedValues.entrySet(), result.entrySet());
    }

    private static final class ClassWithTypeParamExtendingComparable<T extends Comparable> {
        private T t;

        private ClassWithTypeParamExtendingComparable() {
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }
    }

    private static final class ClassWithTypeParam<T> {
        private T t;

        private ClassWithTypeParam() {
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }
    }

    private static final class ClassWithTypeParamAndOtherField<T> {
        private T t;
        private String test;

        private ClassWithTypeParamAndOtherField() {
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }

        public String getTest() {
            return this.test;
        }

        public void setTest(String test) {
            this.test = test;
        }
    }

    @JsonDeserialize(builder=Builder.class)
    private static final class ClassWithBuilder {
        private String field1;

        private ClassWithBuilder() {
        }

        public String getField1() {
            return this.field1;
        }

        @JsonPOJOBuilder(withPrefix="")
        static class Builder {
            private String field1;

            Builder() {
            }

            public Builder field1(String field1) {
                this.field1 = field1;
                return this;
            }

            public ClassWithBuilder build() {
                ClassWithBuilder result = new ClassWithBuilder();
                result.field1 = this.field1;
                return result;
            }
        }
    }

    private static final class ClassWithCreator {
        private String field1;

        @JsonCreator
        public ClassWithCreator(@JsonProperty(value="field1") String field1) {
            this.field1 = field1;
        }

        public String getField1() {
            return this.field1;
        }
    }

    private static final class ClassWithAnnotations {
        private String field1;
        private String field2;

        private ClassWithAnnotations() {
        }

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        @JsonIgnore
        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        @JsonGetter(value="field1")
        String getField1Json() {
            return this.field1;
        }

        @JsonSetter(value="field1")
        void setField1Json(String field1) {
            this.field1 = field1;
        }
    }

    private static final class ClassWithNoFields {
        private ClassWithNoFields() {
        }
    }
}

