/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import uk.gov.gchq.gaffer.commonutil.StringUtil;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.StringSerialiser;
import uk.gov.gchq.gaffer.serialisation.util.LengthValueBytesSerialiserUtil;

public class LengthValueBytesSerialiserUtilTest {
    @Test
    public void shouldSerialiseAndDeserialiseValue() throws IOException {
        byte[] bytes = StringUtil.toBytes((String)"Some value");
        byte[] serialisedBytes = LengthValueBytesSerialiserUtil.serialise((byte[])bytes);
        byte[] deserialisedBytes = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])deserialisedBytes);
    }

    @Test
    public void shouldSerialiseAndDeserialiseValueWithSerialiser() throws IOException {
        String string = "Some value";
        StringSerialiser serialiser = new StringSerialiser();
        byte[] serialisedBytes = LengthValueBytesSerialiserUtil.serialise((ToBytesSerialiser)serialiser, (Object)"Some value");
        String deserialisedString = (String)LengthValueBytesSerialiserUtil.deserialise((ToBytesSerialiser)serialiser, (byte[])serialisedBytes);
        Assert.assertEquals((Object)"Some value", (Object)deserialisedString);
    }

    @Test
    public void shouldSerialiseAndDeserialiseValues() throws IOException {
        byte[] serialisedBytes;
        byte[] bytes1 = StringUtil.toBytes((String)"Some value 1");
        byte[] bytes2 = StringUtil.toBytes((String)"Some value 2");
        byte[] bytes3 = StringUtil.toBytes((String)"Some value 3");
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            LengthValueBytesSerialiserUtil.serialise((byte[])bytes1, (ByteArrayOutputStream)byteStream);
            LengthValueBytesSerialiserUtil.serialise((byte[])bytes2, (ByteArrayOutputStream)byteStream);
            LengthValueBytesSerialiserUtil.serialise((byte[])bytes3, (ByteArrayOutputStream)byteStream);
            serialisedBytes = byteStream.toByteArray();
        }
        int lastDelimiter = 0;
        byte[] deserialisedBytes1 = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes, (int)lastDelimiter);
        lastDelimiter = LengthValueBytesSerialiserUtil.getNextDelimiter((byte[])serialisedBytes, (byte[])deserialisedBytes1, (int)lastDelimiter);
        byte[] deserialisedBytes2 = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes, (int)lastDelimiter);
        lastDelimiter = LengthValueBytesSerialiserUtil.getNextDelimiter((byte[])serialisedBytes, (byte[])deserialisedBytes2, (int)lastDelimiter);
        byte[] deserialisedBytes3 = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes, (int)lastDelimiter);
        Assert.assertArrayEquals((byte[])bytes1, (byte[])deserialisedBytes1);
        Assert.assertArrayEquals((byte[])bytes2, (byte[])deserialisedBytes2);
        Assert.assertArrayEquals((byte[])bytes3, (byte[])deserialisedBytes3);
    }

    @Test
    public void shouldSerialiseAndDeserialiseValuesWithSerialiser() throws IOException {
        byte[] serialisedBytes;
        StringSerialiser stringSerialiser = new StringSerialiser();
        String string1 = "Some value 1";
        String string2 = "Some value 2";
        String string3 = "Some value 3";
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            LengthValueBytesSerialiserUtil.serialise((ToBytesSerialiser)stringSerialiser, (Object)"Some value 1", (ByteArrayOutputStream)byteStream);
            LengthValueBytesSerialiserUtil.serialise((ToBytesSerialiser)stringSerialiser, (Object)"Some value 2", (ByteArrayOutputStream)byteStream);
            LengthValueBytesSerialiserUtil.serialise((ToBytesSerialiser)stringSerialiser, (Object)"Some value 3", (ByteArrayOutputStream)byteStream);
            serialisedBytes = byteStream.toByteArray();
        }
        int[] delimiter = new int[]{0};
        String deserialisedString1 = (String)LengthValueBytesSerialiserUtil.deserialise((ToBytesSerialiser)stringSerialiser, (byte[])serialisedBytes, (int[])delimiter);
        String deserialisedString2 = (String)LengthValueBytesSerialiserUtil.deserialise((ToBytesSerialiser)stringSerialiser, (byte[])serialisedBytes, (int[])delimiter);
        String deserialisedString3 = (String)LengthValueBytesSerialiserUtil.deserialise((ToBytesSerialiser)stringSerialiser, (byte[])serialisedBytes, (int[])delimiter);
        Assert.assertEquals((Object)"Some value 1", (Object)deserialisedString1);
        Assert.assertEquals((Object)"Some value 2", (Object)deserialisedString2);
        Assert.assertEquals((Object)"Some value 3", (Object)deserialisedString3);
    }

    @Test
    public void shouldSerialiseAndDeserialiseNullValue() throws IOException {
        byte[] bytes = null;
        byte[] serialisedBytes = LengthValueBytesSerialiserUtil.serialise(bytes);
        byte[] deserialisedBytes = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])deserialisedBytes);
    }

    @Test
    public void shouldSerialiseAndDeserialiseEmptyValue() throws IOException {
        byte[] bytes = new byte[]{};
        byte[] serialisedBytes = LengthValueBytesSerialiserUtil.serialise((byte[])bytes);
        byte[] deserialisedBytes = LengthValueBytesSerialiserUtil.deserialise((byte[])serialisedBytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])deserialisedBytes);
    }

    @Test
    public void shouldDeserialiseEmptyValue() throws IOException {
        byte[] bytes = new byte[]{};
        byte[] deserialisedBytes = LengthValueBytesSerialiserUtil.deserialise((byte[])bytes);
        Assert.assertArrayEquals((byte[])bytes, (byte[])deserialisedBytes);
    }

    @Test
    public void shouldDeserialiseNullValue() throws IOException {
        byte[] bytes = null;
        byte[] deserialisedBytes = LengthValueBytesSerialiserUtil.deserialise(bytes);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])deserialisedBytes);
    }
}

