/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.gov.gchq.gaffer.core.exception.GafferCheckedException;
import uk.gov.gchq.gaffer.serialisation.IntegerSerialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.MultiSerialiserStorage;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.RawIntegerSerialiser;

public class MultiSerialiserStorageTest {
    public static final byte BYTE = 0;
    public static final ToBytesSerialiser SERIALISER_CLASS = new IntegerSerialiser();
    public static final int VALUE = 1;
    public static final ToBytesSerialiser SERIALISER_CLASS2 = new RawIntegerSerialiser();
    public static final Class SUPPORTED_CLASS = Integer.class;
    private MultiSerialiserStorage mss;

    @Before
    public void setUp() throws Exception {
        this.mss = new MultiSerialiserStorage();
    }

    @Test
    public void shouldPutAndGet() throws Exception {
        this.mss.put((byte)0, SERIALISER_CLASS, SUPPORTED_CLASS);
        this.checkBasicPut();
    }

    @Test
    public void shouldNotRetainOldSerialiserWhenKeyIsOverWritten() throws Exception {
        this.mss.put((byte)0, SERIALISER_CLASS, SUPPORTED_CLASS);
        this.mss.put((byte)0, SERIALISER_CLASS2, SUPPORTED_CLASS);
        Assert.assertNotNull((Object)this.mss.getKeyFromValue((Object)1));
        Assert.assertEquals((String)"Wrong key for value", (Object)0, (Object)this.mss.getKeyFromValue((Object)1));
        ToBytesSerialiser actualClassFromByte = this.mss.getSerialiserFromKey(Byte.valueOf((byte)0));
        Assert.assertNotNull((String)"Byte key not found", (Object)actualClassFromByte);
        Assert.assertEquals((String)"Wrong new SerialiserClass returned for key", (Object)SERIALISER_CLASS2, (Object)actualClassFromByte);
        ToBytesSerialiser actualClassFromValue = this.mss.getSerialiserFromValue((Object)Integer.MAX_VALUE);
        Assert.assertNotNull((String)"Value class not found", (Object)actualClassFromValue);
        Assert.assertEquals((String)"Wrong new SerialiserClass returned for value class", (Object)SERIALISER_CLASS2, (Object)actualClassFromValue);
    }

    @Test
    public void shouldUpdateToNewerValueToSerialiser() throws Exception {
        byte serialiserEncoding = 1;
        this.mss.put(serialiserEncoding, SERIALISER_CLASS2, SUPPORTED_CLASS);
        this.mss.put((byte)0, SERIALISER_CLASS, SUPPORTED_CLASS);
        this.checkBasicPut();
        Assert.assertEquals((long)0L, (long)this.mss.getKeyFromValue((Object)1).byteValue());
        ToBytesSerialiser actualClassFromByte2 = this.mss.getSerialiserFromKey(Byte.valueOf(serialiserEncoding));
        Assert.assertNotNull((String)"Byte key not found", (Object)actualClassFromByte2);
        Assert.assertEquals((String)"Wrong SerialiserClass returned for key", (Object)SERIALISER_CLASS2, (Object)actualClassFromByte2);
        ToBytesSerialiser actualClassFromValue2 = this.mss.getSerialiserFromValue((Object)Integer.MAX_VALUE);
        Assert.assertNotNull((String)"Value class not found", (Object)actualClassFromValue2);
        Assert.assertEquals((String)"Wrong SerialiserClass, should have updated to newer SerialiserClass", (Object)SERIALISER_CLASS, (Object)actualClassFromValue2);
    }

    private void checkBasicPut() throws GafferCheckedException {
        Assert.assertEquals((Object)0, (Object)this.mss.getKeyFromValue((Object)1));
        ToBytesSerialiser actualClassFromByte = this.mss.getSerialiserFromKey(Byte.valueOf((byte)0));
        Assert.assertNotNull((String)"Byte key not found", (Object)actualClassFromByte);
        Assert.assertEquals((String)"Wrong SerialiserClass returned for key", (Object)SERIALISER_CLASS, (Object)actualClassFromByte);
        ToBytesSerialiser actualClassFromValue = this.mss.getSerialiserFromValue((Object)Integer.MAX_VALUE);
        Assert.assertNotNull((String)"Value class not found", (Object)actualClassFromValue);
        Assert.assertEquals((String)"Wrong SerialiserClass returned for value class", (Object)SERIALISER_CLASS, (Object)actualClassFromValue);
    }
}

