/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.jsonserialisation.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterable;

public class CloseableIterableDeserializer
extends JsonDeserializer<CloseableIterable<?>>
implements ContextualDeserializer {
    private JavaType valueType;

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CloseableIterable.class, (JsonDeserializer)new CloseableIterableDeserializer());
        return module;
    }

    public CloseableIterable<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        CollectionType typeReference = ctxt.getTypeFactory().constructCollectionType(List.class, this.valueType);
        return new WrappedCloseableIterable((Iterable)ctxt.readValue(jp, (JavaType)typeReference));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty property) throws JsonMappingException {
        JavaType valueType = deserializationContext.getContextualType().containedType(0);
        CloseableIterableDeserializer deserializer = new CloseableIterableDeserializer();
        deserializer.valueType = valueType;
        return deserializer;
    }
}

