/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;

public interface ToBytesSerialiser<T>
extends Serialiser<T, byte[]> {
    public static final byte[] EMPTY_BYTES = new byte[0];

    @Override
    default public byte[] serialiseNull() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] serialise(T var1) throws SerialisationException;

    default public T deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        byte[] selection = new byte[length];
        try {
            System.arraycopy(allBytes, offset, selection, 0, length);
        }
        catch (NullPointerException e) {
            throw new SerialisationException(String.format("Deserialising with giving range caused ArrayIndexOutOfBoundsException. byte[].size:%d startPos:%d length:%d", allBytes.length, 0, length), e);
        }
        return this.deserialise(selection);
    }

    @Override
    public T deserialise(byte[] var1) throws SerialisationException;

    @Override
    public T deserialiseEmpty() throws SerialisationException;

    @Override
    public boolean preservesObjectOrdering();
}

