/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation;

import java.io.UnsupportedEncodingException;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;

public abstract class ToBytesViaStringDeserialiser<T>
implements ToBytesSerialiser<T> {
    private String charset;

    public ToBytesViaStringDeserialiser(String charsetName) {
        this.charset = charsetName;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    @Deprecated
    public final T deserialise(byte[] bytes) throws SerialisationException {
        return this.deserialise(bytes, 0, bytes.length);
    }

    @Override
    public final T deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        try {
            String valueString = new String(allBytes, offset, length, this.charset);
            return this.deserialiseString(valueString);
        }
        catch (UnsupportedEncodingException | StringIndexOutOfBoundsException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    protected abstract T deserialiseString(String var1) throws SerialisationException;

    @Override
    public byte[] serialise(T object) throws SerialisationException {
        String str;
        try {
            str = this.serialiseToString(object);
        }
        catch (Exception e) {
            throw new SerialisationException("failed to convert object to string for serialisation.", e);
        }
        if (null != str) {
            try {
                return str.getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                throw new SerialisationException("Unable to serialise to bytes using charset: " + this.getCharset(), e);
            }
        }
        return this.serialiseNull();
    }

    protected abstract String serialiseToString(T var1) throws SerialisationException;
}

