/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;

public class BooleanSerialiser
implements ToBytesSerialiser<Boolean> {
    private static final long serialVersionUID = -3964992157560886710L;
    private static final byte FALSE = 0;
    private static final byte TRUE = 1;

    @Override
    public byte[] serialise(Boolean value) throws SerialisationException {
        return new byte[]{Boolean.TRUE.equals(value) ? (byte)1 : 0};
    }

    @Override
    public Boolean deserialise(byte[] bytes) throws SerialisationException {
        return this.deserialise(bytes, 0, bytes.length);
    }

    @Override
    public Boolean deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        return length == 1 && 1 == allBytes[offset];
    }

    @Override
    public Boolean deserialiseEmpty() {
        return Boolean.FALSE;
    }

    public <T> T deserialise(byte[] bytes, Class<T> clazz) throws SerialisationException {
        return clazz.cast(bytes.length == 1 && 1 == bytes[0]);
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Boolean.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

