/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;

public class JavaSerialiser
implements ToBytesSerialiser<Object> {
    private static final long serialVersionUID = 2073581763875104361L;
    private static final Class<Serializable> SERIALISABLE = Serializable.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSerialiser.class);

    @Override
    public byte[] serialise(Object object) throws SerialisationException {
        ObjectOutputStream out = null;
        ByteArrayOutputStream byteOut = null;
        try {
            byteOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(byteOut);
            out.writeObject(object);
            byte[] byArray = byteOut.toByteArray();
            this.close(out);
            this.close(byteOut);
            return byArray;
        }
        catch (IOException e) {
            try {
                throw new SerialisationException("Unable to serialise given object of class: " + object.getClass().getName() + ", does it implement the serializable interface?", e);
            }
            catch (Throwable throwable) {
                this.close(out);
                this.close(byteOut);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(allBytes, offset, length));){
            Object object = is.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerialisationException("Unable to deserialise object, failed to recreate object", e);
        }
    }

    @Override
    public Object deserialise(byte[] bytes) throws SerialisationException {
        return this.deserialise(bytes, 0, bytes.length);
    }

    @Override
    public Object deserialiseEmpty() {
        return null;
    }

    private void close(Closeable close) {
        if (null != close) {
            try {
                close.close();
            }
            catch (IOException e) {
                LOGGER.warn("Resource leak: unable to close stream in JavaSerialiser.class", (Throwable)e);
            }
        }
    }

    @Override
    public boolean canHandle(Class clazz) {
        return SERIALISABLE.isAssignableFrom(clazz);
    }

    @Override
    public boolean preservesObjectOrdering() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return false;
    }
}

