/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.gov.gchq.gaffer.core.exception.GafferCheckedException;
import uk.gov.gchq.gaffer.serialisation.Serialiser;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.MultiSerialiser;

public class MultiSerialiserStorage {
    public static final String ERROR_ADDING_MULTI_SERIALISER = "Adding nested MultiSerialiser within a MultiSerialiser is not supported yet.";
    private final Map<Byte, ToBytesSerialiser> keyToSerialiser = new HashMap<Byte, ToBytesSerialiser>();
    private final Map<Byte, Class> keyToClass = new HashMap<Byte, Class>();
    private final Map<Class, Byte> classToKey = new HashMap<Class, Byte>();
    private boolean consistent = true;
    private boolean preservesObjectOrdering = true;

    public void put(byte serialiserEncoding, ToBytesSerialiser serialiser, Class supportedClass) throws GafferCheckedException {
        this.validatePutParams(serialiser, supportedClass);
        this.consistent = this.continuesToBeConsistant(serialiser);
        this.preservesObjectOrdering = this.continuesToPreserveOrdering(serialiser);
        this.keyToSerialiser.put(serialiserEncoding, serialiser);
        this.keyToClass.put(serialiserEncoding, supportedClass);
        this.classToKey.put(supportedClass, serialiserEncoding);
    }

    private void validatePutParams(ToBytesSerialiser serialiser, Class supportedClass) throws GafferCheckedException {
        if (null == supportedClass) {
            throw new GafferCheckedException(String.format("Can not add null supportedClass to MultiSerialiserStorage", new Object[0]));
        }
        if (null == serialiser) {
            throw new GafferCheckedException(String.format("Can not add null serialiser to MultiSerialiserStorage", new Object[0]));
        }
        if (!serialiser.canHandle(supportedClass)) {
            throw new GafferCheckedException(String.format("%s does not handle %s", serialiser.getClass(), supportedClass));
        }
    }

    public ToBytesSerialiser getSerialiserFromKey(Byte key) {
        return null == key ? null : this.keyToSerialiser.get(key);
    }

    public Byte getKeyFromValue(Object object) {
        return null == object ? null : this.classToKey.get(object.getClass());
    }

    public ToBytesSerialiser getSerialiserFromValue(Object object) {
        return null == object ? null : this.getSerialiserFromKey(this.getKeyFromValue(object));
    }

    public boolean canHandle(Class handleClass) {
        boolean rtn = false;
        Byte key = this.classToKey.get(handleClass);
        if (null != key) {
            Serialiser serialiser = this.keyToSerialiser.get(key);
            rtn = null != serialiser && serialiser.canHandle(handleClass);
        }
        return rtn;
    }

    private boolean continuesToPreserveOrdering(ToBytesSerialiser toBytesSerialiser) {
        return this.preservesObjectOrdering && toBytesSerialiser.preservesObjectOrdering();
    }

    private boolean continuesToBeConsistant(ToBytesSerialiser toBytesSerialiser) {
        return this.consistent && toBytesSerialiser.isConsistent();
    }

    public boolean preservesObjectOrdering() {
        return this.preservesObjectOrdering;
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public void addSerialiserDetails(byte key, ToBytesSerialiser serialiser, Class aClass) throws GafferCheckedException {
        this.addSerialiserDetails(new SerialiserDetail(key, serialiser, aClass));
    }

    public void addSerialiserDetails(SerialiserDetail serialiserDetail) throws GafferCheckedException {
        if (null != serialiserDetail) {
            if (serialiserDetail.getSerialiser() instanceof MultiSerialiser) {
                throw new GafferCheckedException(ERROR_ADDING_MULTI_SERIALISER);
            }
            this.put(serialiserDetail.getKey(), serialiserDetail.getSerialiser(), serialiserDetail.getValueClass());
        }
    }

    public List<SerialiserDetail> getSerialiserDetails() {
        return this.keyToSerialiser.keySet().stream().map(key -> new SerialiserDetail((byte)key, this.keyToSerialiser.get(key), this.keyToClass.get(key))).collect(Collectors.toList());
    }

    public void setSerialiserDetails(List<SerialiserDetail> serialisersDetails) throws GafferCheckedException {
        this.clear();
        if (null != serialisersDetails) {
            for (SerialiserDetail serialiser : serialisersDetails) {
                this.addSerialiserDetails(serialiser);
            }
        }
    }

    private void clear() {
        this.keyToSerialiser.clear();
        this.keyToClass.clear();
        this.classToKey.clear();
    }

    @JsonPropertyOrder(value={"class", "key", "serialiser", "valueClass"}, alphabetic=true)
    public static class SerialiserDetail {
        private byte key;
        private ToBytesSerialiser serialiser;
        private Class valueClass;

        public SerialiserDetail() {
        }

        public SerialiserDetail(byte key, ToBytesSerialiser serialiser, Class valueClass) {
            this();
            this.key = key;
            this.serialiser = serialiser;
            this.valueClass = valueClass;
        }

        public byte getKey() {
            return this.key;
        }

        public SerialiserDetail key(byte key) {
            this.key = key;
            return this;
        }

        public Class getValueClass() {
            return this.valueClass;
        }

        public SerialiserDetail valueClass(Class valueClass) {
            this.valueClass = valueClass;
            return this;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
        public ToBytesSerialiser getSerialiser() {
            return this.serialiser;
        }

        public SerialiserDetail serialiser(ToBytesSerialiser serialiser) {
            this.serialiser = serialiser;
            return this;
        }
    }
}

