/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.TreeSet;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesViaStringDeserialiser;

public class TreeSetStringSerialiser
extends ToBytesViaStringDeserialiser<TreeSet<String>> {
    private static final long serialVersionUID = -8241328807929077861L;
    private static final String COMMA = "\\,";
    private static final String OPEN = "{";
    private static final String CLOSE = "}";

    public TreeSetStringSerialiser() {
        super("UTF-8");
    }

    @Override
    public boolean canHandle(Class clazz) {
        return TreeSet.class.isAssignableFrom(clazz);
    }

    @Override
    protected String serialiseToString(TreeSet<String> object) throws SerialisationException {
        StringBuilder builder = new StringBuilder(OPEN);
        Iterator<String> values = object.iterator();
        if (values.hasNext()) {
            builder.append((Object)values.next());
        }
        while (values.hasNext()) {
            builder.append(COMMA).append((Object)values.next());
        }
        builder.append(CLOSE);
        return builder.toString();
    }

    @Override
    public TreeSet<String> deserialiseString(String value) throws SerialisationException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterable items = Splitter.on((String)COMMA).omitEmptyStrings().split((CharSequence)value.substring(1, value.length() - 1));
        for (String item : items) {
            treeSet.add(item);
        }
        return treeSet;
    }

    @Override
    public TreeSet<String> deserialiseEmpty() {
        return new TreeSet<String>();
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

