/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import java.util.Date;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedLongSerialiser;

public class OrderedDateSerialiser
implements ToBytesSerialiser<Date> {
    private static final long serialVersionUID = 6636121009320739764L;
    private static final OrderedLongSerialiser LONG_SERIALISER = new OrderedLongSerialiser();

    @Override
    public byte[] serialise(Date object) {
        return LONG_SERIALISER.serialise(object.getTime());
    }

    @Override
    public Date deserialise(byte[] bytes) throws SerialisationException {
        return new Date(LONG_SERIALISER.deserialise(bytes));
    }

    @Override
    public Date deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Date.class.equals((Object)clazz);
    }
}

