/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawSerialisationUtils;

public class CompactRawLongSerialiser
implements ToBytesSerialiser<Long> {
    private static final long serialVersionUID = 6104372357426908732L;

    @Override
    public boolean canHandle(Class clazz) {
        return Long.class.equals((Object)clazz);
    }

    @Override
    public byte[] serialise(Long l) throws SerialisationException {
        return CompactRawSerialisationUtils.writeLong(l);
    }

    @Override
    public Long deserialise(byte[] allBytes, int offset, int length) throws SerialisationException {
        return CompactRawSerialisationUtils.readLong(allBytes, offset);
    }

    @Override
    public Long deserialise(byte[] bytes) throws SerialisationException {
        return CompactRawSerialisationUtils.readLong(bytes);
    }

    @Override
    public Long deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

