/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public final class JsonSerialisationUtil {
    private static Map<String, Map<String, String>> cache = Collections.emptyMap();

    private JsonSerialisationUtil() {
    }

    public static Map<String, String> getSerialisedFieldClasses(String className) {
        JsonPOJOBuilder anno;
        Class<?> clazz;
        Map<String, String> cachedResult = cache.get(className);
        if (null != cachedResult) {
            return cachedResult;
        }
        try {
            clazz = Class.forName(SimpleClassNameIdResolver.getClassName((String)className));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class name was not recognised: " + className, e);
        }
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(clazz);
        BeanDescription introspection = mapper.getSerializationConfig().introspect(type);
        Class builder = introspection.findPOJOBuilder();
        String buildMethodPrefix = "with";
        if (null != builder && null != (anno = JsonSerialisationUtil.findAnnotation(builder, JsonPOJOBuilder.class))) {
            buildMethodPrefix = anno.withPrefix();
        }
        Constructor<?> creator = null;
        for (Constructor<?> constructor : type.getRawClass().getDeclaredConstructors()) {
            JsonCreator anno2 = constructor.getAnnotation(JsonCreator.class);
            if (null == anno2) continue;
            creator = constructor;
            break;
        }
        List properties = introspection.findProperties();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (BeanPropertyDefinition property : properties) {
            String propClass;
            String propName = property.getName();
            if ("class".equals(propName)) {
                propClass = Class.class.getName();
            } else {
                Class<?> genericType = null;
                if (null != builder) {
                    String methodName = buildMethodPrefix + propName;
                    Method matchedMethod = null;
                    for (Method method : builder.getMethods()) {
                        Type[] params;
                        if (!methodName.equalsIgnoreCase(method.getName()) || null == (params = method.getGenericParameterTypes()) || 1 != params.length) continue;
                        JsonSetter jsonSetter = method.getAnnotation(JsonSetter.class);
                        if (null != jsonSetter && propName.equals(jsonSetter.value())) {
                            matchedMethod = method;
                            break;
                        }
                        JsonProperty jsonProperty = method.getAnnotation(JsonProperty.class);
                        if (null != jsonProperty && propName.equals(jsonProperty.value())) {
                            matchedMethod = method;
                            break;
                        }
                        if (null == matchedMethod) {
                            matchedMethod = method;
                            continue;
                        }
                        if (!builder.equals(method.getReturnType())) continue;
                        matchedMethod = method;
                    }
                    if (null != matchedMethod) {
                        genericType = matchedMethod.getGenericParameterTypes()[0];
                    }
                }
                if (null == genericType && null != creator) {
                    for (Parameter parameter : creator.getParameters()) {
                        JsonProperty anno3 = parameter.getAnnotation(JsonProperty.class);
                        if (null == anno3 || !propName.equals(anno3.value())) continue;
                        if (null != parameter.getParameterizedType()) {
                            genericType = parameter.getParameterizedType();
                            break;
                        }
                        genericType = parameter.getType();
                        break;
                    }
                }
                if (null == genericType && null != property.getSetter() && null != property.getSetter().getGenericParameterTypes() && 1 == property.getSetter().getGenericParameterTypes().length) {
                    genericType = property.getSetter().getGenericParameterTypes()[0];
                }
                if (null != genericType && genericType instanceof Class && ((Class)genericType).isEnum()) {
                    genericType = String.class;
                }
                propClass = null == genericType ? Object.class.getName() : JsonSerialisationUtil.getFieldTypeString(clazz, genericType);
            }
            fieldMap.put(propName, propClass);
        }
        HashMap<String, Map<String, String>> newCache = new HashMap<String, Map<String, String>>(cache);
        newCache.put(className, Collections.unmodifiableMap(fieldMap));
        cache = Collections.unmodifiableMap(newCache);
        return fieldMap;
    }

    public static String getTypeString(Type typeArg) {
        return JsonSerialisationUtil.getFieldTypeString(null, typeArg);
    }

    public static String getFieldTypeString(Class<?> clazz, Type typeArg) {
        String typeName = null;
        boolean isArray = typeArg instanceof GenericArrayTypeImpl;
        Type type = typeArg;
        if (isArray) {
            type = ((GenericArrayTypeImpl)typeArg).getGenericComponentType();
        }
        if (type instanceof TypeVariable) {
            Type propType;
            Map typeArgs;
            TypeVariable tv = (TypeVariable)type;
            Object genericDeclaration = tv.getGenericDeclaration();
            if (null != clazz && genericDeclaration instanceof Class && null != (typeArgs = TypeUtils.getTypeArguments(clazz, (Class)((Class)genericDeclaration))) && null != (propType = (Type)typeArgs.get(tv))) {
                typeName = propType.getTypeName();
            }
            if (null == typeName) {
                typeName = null != tv.getBounds() && 1 == tv.getBounds().length ? tv.getBounds()[0].getTypeName() : type.getTypeName();
            }
        } else {
            typeName = type.getTypeName();
        }
        if (null != typeName) {
            if (isArray) {
                typeName = typeName + "[]";
            }
            if (!typeName.contains(".")) {
                typeName = SimpleClassNameIdResolver.getClassName((String)typeName);
            }
            typeName = typeName.replaceAll("\\? extends ", "").replaceAll("\\? super ", "").replaceAll(" ", "");
        }
        return typeName;
    }

    private static <T extends Annotation> T findAnnotation(Class<?> builderclass, Class<T> annotationClass) {
        T anno = builderclass.getAnnotation(annotationClass);
        if (null == anno) {
            Class<?> superClass = builderclass.getSuperclass();
            while (null != superClass && null == anno) {
                anno = superClass.getAnnotation(annotationClass);
                if (null != anno) continue;
                superClass = superClass.getSuperclass();
            }
        }
        if (null == anno) {
            for (Class<?> interfaceClass : builderclass.getInterfaces()) {
                if (null != interfaceClass && null != (anno = interfaceClass.getAnnotation(annotationClass))) break;
            }
        }
        return anno;
    }
}

