/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import httpstub.RecordedRequest;
import httpstub.RequestAndResponse;
import httpstub.StubHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public abstract class AbstractHttpStub {
    protected static final int RANDOM_PORT = 0;
    protected Server server;
    protected List<RecordedRequest> recordedRequests = new CopyOnWriteArrayList<RecordedRequest>();
    protected List<RequestAndResponse> requestsAndResponses = new CopyOnWriteArrayList<RequestAndResponse>();

    public AbstractHttpStub(int port) {
        this.server = new Server(port);
        this.server.setHandler((Handler)this.createHandler());
    }

    public final void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public final void stop() throws Exception {
        this.server.setStopTimeout(0L);
        this.server.stop();
    }

    public final void reset() {
        this.recordedRequests.clear();
        this.requestsAndResponses.clear();
    }

    public final int getHttpPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    public final void register(RequestAndResponse requestAndResponse) {
        this.requestsAndResponses.add(requestAndResponse);
    }

    public final int getCountOfRequestsTo(final String path) {
        return Iterables.size((Iterable)Iterables.filter(this.recordedRequests, (Predicate)new Predicate<RecordedRequest>(){

            public boolean apply(RecordedRequest input) {
                return input.getPath().equals(path);
            }
        }));
    }

    public final List<RecordedRequest> getRecordedRequests() {
        return this.recordedRequests;
    }

    public final RecordedRequest getLastRequest() {
        return (RecordedRequest)Iterables.getLast(this.recordedRequests);
    }

    public final int getCountOfRequests() {
        return this.recordedRequests.size();
    }

    public abstract StubHandler createHandler();
}

