/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class ReceivedRequest {
    protected final String requestURI;
    protected final ImmutableMultimap<String, String> headers;
    protected final String querystring;
    protected final String method;
    protected final String url;
    protected byte[] entity;

    public ReceivedRequest(HttpServletRequest request) {
        this.method = request.getMethod();
        this.url = request.getRequestURL().toString();
        this.querystring = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.headers = ReceivedRequest.getHeaders(request);
        this.entity = ReceivedRequest.readEntity(request);
    }

    protected static byte[] readEntity(HttpServletRequest request) {
        byte[] byArray;
        block8: {
            ServletInputStream in = request.getInputStream();
            try {
                byArray = IOUtils.toByteArray((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            in.close();
        }
        return byArray;
    }

    protected static ImmutableMultimap<String, String> getHeaders(HttpServletRequest request) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            builder.putAll((Object)headerName.toLowerCase(), (Iterable)ImmutableList.copyOf((Iterator)Iterators.forEnumeration((Enumeration)request.getHeaders(headerName))));
        }
        return builder.build();
    }

    public String getPath() {
        return this.requestURI;
    }

    public String getUrl() {
        return this.url;
    }

    public ImmutableMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        ImmutableCollection values = this.headers.get((Object)name.toLowerCase());
        return values == null ? null : (String)Iterables.getFirst((Iterable)values, null);
    }

    public String getQuerystring() {
        return this.querystring;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getEntityBytes() {
        return this.entity;
    }

    @Deprecated
    public String getEntity() {
        return new String(this.entity);
    }
}

