/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.shared.utils.featuretoggles;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.shared.utils.featuretoggles.FeatureEntry;

public class FeatureConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureConfiguration.class);
    @Valid
    public List<FeatureEntry> features = ImmutableList.of();
    @Valid
    @NotNull
    public String featureClass;

    public boolean isFeatureActive(String feature) {
        for (FeatureEntry entry : this.features) {
            if (!entry.getFeatureName().equals(feature)) continue;
            return entry.isActive();
        }
        LOG.error(MessageFormat.format("Attempted to use unknown feature flag: {0}", feature));
        return false;
    }

    public List<FeatureEntry> getFeatures() {
        return this.features;
    }

    public String getFeatureClass() {
        return this.featureClass;
    }
}

