/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators.assertion;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.extensions.Address;
import uk.gov.ida.saml.core.extensions.Date;
import uk.gov.ida.saml.core.extensions.Gender;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorManager;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationWarning;
import uk.gov.ida.saml.core.validators.assertion.DuplicateAssertionValidator;
import uk.gov.ida.saml.hub.exception.SamlValidationException;

public class MatchingDatasetAssertionValidator {
    private static final Set<String> VALID_ATTRIBUTE_NAMES_1_1 = Set.of("MDS_firstname", "MDS_middlename", "MDS_surname", "MDS_gender", "MDS_dateofbirth", "MDS_currentaddress", "MDS_previousaddress");
    private static final Set<String> VALID_ATTRIBUTE_NAME_FORMATS = Set.of("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
    private static final Map<String, QName> VALID_TYPE_FOR_ATTRIBUTE = Map.of("MDS_firstname", PersonName.TYPE_NAME, "MDS_middlename", PersonName.TYPE_NAME, "MDS_surname", PersonName.TYPE_NAME, "MDS_gender", Gender.TYPE_NAME, "MDS_dateofbirth", Date.TYPE_NAME, "MDS_currentaddress", Address.TYPE_NAME, "MDS_previousaddress", Address.TYPE_NAME);
    private final DuplicateAssertionValidator duplicateAssertionValidator;

    public MatchingDatasetAssertionValidator(DuplicateAssertionValidator duplicateAssertionValidator) {
        this.duplicateAssertionValidator = duplicateAssertionValidator;
    }

    public void validate(Assertion assertion, String responseIssuerId) {
        this.duplicateAssertionValidator.validateMatchingDataSetAssertion(assertion, responseIssuerId);
        this.validateAttributes(assertion);
    }

    private void validateAttributes(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements.isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.mdsStatementMissing());
        }
        if (attributeStatements.size() > 1) {
            throw new SamlValidationException(SamlTransformationErrorFactory.mdsMultipleStatements());
        }
        List attributes = ((AttributeStatement)attributeStatements.get(0)).getAttributes();
        if (attributes.isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.attributeStatementEmpty((String)assertion.getID()));
        }
        attributes.forEach(this::validateAttribute);
    }

    private void validateAttribute(Attribute attribute) {
        String attributeName = attribute.getName();
        if (!VALID_ATTRIBUTE_NAMES_1_1.contains(attributeName)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.mdsAttributeNotRecognised((String)attributeName));
        }
        List attributeValues = attribute.getAttributeValues();
        if (attributeValues.isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.emptyAttribute((String)attributeName));
        }
        QName schemaType = ((XMLObject)attributeValues.get(0)).getSchemaType();
        if (!VALID_TYPE_FOR_ATTRIBUTE.get(attributeName).equals(schemaType)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.attributeWithIncorrectType((String)attributeName, (QName)VALID_TYPE_FOR_ATTRIBUTE.get(attributeName), (QName)schemaType));
        }
        if (!VALID_ATTRIBUTE_NAME_FORMATS.contains(attribute.getNameFormat())) {
            SamlTransformationErrorManager.warn((SamlValidationSpecificationWarning)SamlTransformationErrorFactory.invalidAttributeNameFormat((String)attribute.getNameFormat()));
        }
    }
}

