/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.domain;

import java.util.Optional;
import uk.gov.ida.saml.core.domain.IdaStatus;
import uk.gov.ida.saml.hub.domain.AuthenticationStatusFactory;

public final class IdpIdaStatus
implements IdaStatus {
    private Status status;
    private Optional<String> message = Optional.empty();

    public static IdpIdaStatus success() {
        return new IdpIdaStatus(Status.Success);
    }

    public static IdpIdaStatus authenticationFailed() {
        return new IdpIdaStatus(Status.AuthenticationFailed);
    }

    public static IdpIdaStatus noAuthenticationContext() {
        return new IdpIdaStatus(Status.NoAuthenticationContext);
    }

    public static IdpIdaStatus requesterError() {
        return new IdpIdaStatus(Status.RequesterError);
    }

    public static IdpIdaStatus requesterError(Optional<String> errorMessage) {
        return new IdpIdaStatus(Status.RequesterError, errorMessage);
    }

    public static IdpIdaStatus authenticationCancelled() {
        return new IdpIdaStatus(Status.AuthenticationCancelled);
    }

    public static IdpIdaStatus authenticationPending() {
        return new IdpIdaStatus(Status.AuthenticationPending);
    }

    public static IdpIdaStatus upliftFailed() {
        return new IdpIdaStatus(Status.UpliftFailed);
    }

    private IdpIdaStatus() {
    }

    private IdpIdaStatus(Status status) {
        this(status, Optional.empty());
    }

    private IdpIdaStatus(Status status, Optional<String> message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatusCode() {
        return this.status;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdpIdaStatus idpIdaStatus = (IdpIdaStatus)o;
        return this.status == idpIdaStatus.status;
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = 31 * result;
        return result;
    }

    public String toString() {
        return "IdaStatus{status=" + this.status + ", message=" + this.message + "}";
    }

    public static class IdpIdaStatusFactory
    implements AuthenticationStatusFactory<Status, IdpIdaStatus> {
        @Override
        public IdpIdaStatus create(Status statusCode, String message) {
            if (!statusCode.equals((Object)Status.RequesterError)) {
                return new IdpIdaStatus(statusCode);
            }
            return new IdpIdaStatus(statusCode, Optional.ofNullable(message));
        }
    }

    public static enum Status {
        Success,
        NoAuthenticationContext,
        RequesterError,
        AuthenticationFailed,
        AuthenticationCancelled,
        AuthenticationPending,
        UpliftFailed;

    }
}

