/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.inbound;

import com.google.inject.Inject;
import java.util.Optional;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.core.domain.FraudDetectedDetails;
import uk.gov.ida.saml.core.domain.InboundResponseFromIdpData;
import uk.gov.ida.saml.core.domain.PassthroughAssertion;
import uk.gov.ida.saml.core.transformers.outbound.decorators.AssertionBlobEncrypter;
import uk.gov.ida.saml.hub.domain.InboundResponseFromIdp;

public class InboundResponseFromIdpDataGenerator {
    private AssertionBlobEncrypter assertionBlobEncrypter;

    @Inject
    public InboundResponseFromIdpDataGenerator(AssertionBlobEncrypter assertionBlobEncrypter) {
        this.assertionBlobEncrypter = assertionBlobEncrypter;
    }

    public InboundResponseFromIdpData generate(InboundResponseFromIdp idaResponseFromIdp, String matchingServiceEntityId) {
        Optional principalIpAddressFromIdp = Optional.empty();
        Optional<String> persistentId = Optional.empty();
        Optional<String> idpFraudEventId = Optional.empty();
        Optional<String> fraudIndicator = Optional.empty();
        String levelOfAssurance = null;
        if (idaResponseFromIdp.getAuthnStatementAssertion().isPresent()) {
            PassthroughAssertion authnStatementAssertion = idaResponseFromIdp.getAuthnStatementAssertion().get();
            principalIpAddressFromIdp = authnStatementAssertion.getPrincipalIpAddressAsSeenByIdp();
            persistentId = Optional.ofNullable(authnStatementAssertion.getPersistentId().getNameId());
            if (authnStatementAssertion.getAuthnContext().isPresent()) {
                levelOfAssurance = ((AuthnContext)authnStatementAssertion.getAuthnContext().get()).name();
            }
            if (authnStatementAssertion.getFraudDetectedDetails().isPresent()) {
                idpFraudEventId = Optional.of(((FraudDetectedDetails)authnStatementAssertion.getFraudDetectedDetails().get()).getIdpFraudEventId());
                fraudIndicator = Optional.of(((FraudDetectedDetails)authnStatementAssertion.getFraudDetectedDetails().get()).getFraudIndicator());
            }
        }
        Optional<String> encryptedMatchingDatasetAssertion = idaResponseFromIdp.getMatchingDatasetAssertion().map(PassthroughAssertion::getUnderlyingAssertionBlob).map(blob -> this.assertionBlobEncrypter.encryptAssertionBlob(matchingServiceEntityId, (String)blob));
        Optional<String> encryptedAuthnAssertion = idaResponseFromIdp.getAuthnStatementAssertion().map(PassthroughAssertion::getUnderlyingAssertionBlob).map(blob -> this.assertionBlobEncrypter.encryptAssertionBlob(matchingServiceEntityId, (String)blob));
        return new InboundResponseFromIdpData(idaResponseFromIdp.getStatus().getStatusCode(), idaResponseFromIdp.getStatus().getMessage(), idaResponseFromIdp.getIssuer(), encryptedAuthnAssertion, encryptedMatchingDatasetAssertion, persistentId, principalIpAddressFromIdp, levelOfAssurance, idpFraudEventId, fraudIndicator, idaResponseFromIdp.getNotOnOrAfter());
    }
}

